
""""---------------------------------------------------------------------------
--------------------------------     SETUP     --------------------------------
--------------------------------  References  ---------------------------------
----------------------------------------------------------------------------"""

"""

-*- coding: utf-8 -*-

Created on Tue May  5 16:03:47 2020

@author: 909448 - Jorik Grolle
"""


""""---------------------------------------------------------------------------
--------------------------------     SETUP     --------------------------------
----------------------------  Python Composition  -----------------------------
----------------------------------------------------------------------------"""

from openpyxl import load_workbook
import numpy as np
import time
import math
import matplotlib.pyplot as plt
import seaborn as sns
sns.set(style="darkgrid")
import copy
import seaborn as sns
#from mpl_toolkits.basemap import Basemap            
from colorama import Fore, Back, Style
import heapq
import scipy as sy
from matplotlib.ticker import PercentFormatter
import matplotlib.ticker as mtick
from matplotlib.pyplot import figure
import pandas as pd
import datetime

start_time = time.time()

#np.seterr('raise')

#float rounding error correction
epsilon0 = 0.000001
epsilon1 = 1.000001

#load path string
loading_path_string = "C:\Users\909448\Documents\##AFSTUDEREN\#SIMULATION\ROOM_SEVEN\SCENARIO_F\RUN_A_FM"
saving_path_string  = "C:/Users/909448/Documents/##AFSTUDEREN/#SIMULATION/ROOM_SEVEN/SCENARIO_F/RUN_A_FM"

""""---------------------------------------------------------------------------
--------------------------------     INPUT     --------------------------------
----------------------------  Initial Environment  ----------------------------
----------------------------------------------------------------------------"""
current_time = time.time()
modeltimer = ([[datetime.datetime.fromtimestamp(start_time).strftime('%Y-%m-%d %H:%M:%S'),datetime.datetime.fromtimestamp(current_time).strftime('%Y-%m-%d %H:%M:%S'), current_time - start_time]])



#------------------------------------------------------------------------------

time_begin_init = time.time() #set sub-timer
counter_NAP = 0

#------------------------------------------------------------------------------

# Load excel workbook and according sheets
doc_name     =    "\control_panel.xlsx"
wb           =    load_workbook(loading_path_string+""+doc_name)
ws_UDP       =    wb['User_Defined_Parameters']
ws_vertices  =    wb['Vertices']
ws_edges     =    wb['Edges']
ws_modes     =    wb['Modes']
ws_demand    =    wb['Demand']

#------------------------------------------------------------------------------

# Load User Defined Parameters

#objective function parameters

PSI_user        =    ws_UDP['C3'].value
PSI_operator    =    ws_UDP['C4'].value
PSI_external    =    ws_UDP['C5'].value

norm_weight_factor = float(copy.copy( PSI_user + PSI_operator + PSI_external ))

PSI_user        =    ws_UDP['C3'].value / norm_weight_factor
PSI_operator    =    ws_UDP['C4'].value / norm_weight_factor
PSI_external    =    ws_UDP['C5'].value / norm_weight_factor

fac_use_weight  =    ws_UDP['C7'].value
      
VoT_access      =    float(ws_UDP['C13'].value) #define value of time during access 
VoT_waiting     =    float(ws_UDP['C14'].value) #define value of time during waiting
VoT_invehicle   =    float(ws_UDP['C15'].value) #define value of time during in-vehile
VoT_transfer    =    float(ws_UDP['C16'].value) #define value of time during transfer    
VoT_egress      =    float(ws_UDP['C17'].value) #define value of time during egress

k_closeby_OV          = ws_UDP['C19'].value
k_large_hsr_demand_OV = ws_UDP['C20'].value
k_usage_route_OV      = ws_UDP['C21'].value
k_connecting_OV       = ws_UDP['C22'].value

demand_resolution = float(ws_UDP['C24'].value) # 80% = 537, 90% = 945, 95% = 1337 

#------------------------------------------------------------------------------

# Load vertex characteristics

V = np.array([[i.value for i in j] for j in ws_vertices['B2':'DV2']]) 
XX = np.zeros(len(V[0]), dtype=object)
for i in range(len(XX)):
    XX[i] = V[0,i]
V = XX #set of vertices

length_V = copy.deepcopy(len(V))
range_len_V = copy.deepcopy(range(length_V))

V_lat = np.array([[i.value for i in j] for j in ws_vertices['B3':'DV3']]) 
XX = np.zeros(length_V)
for i in range(len(XX)):
    XX[i] = V_lat[0,i]
V_lat = XX #vertex latitudes
  
V_lon = np.array([[i.value for i in j] for j in ws_vertices['B4':'DV4']]) 
XX = np.zeros(length_V)
for i in range(len(XX)):
    XX[i] = V_lon[0,i]
V_lon = XX #vertex longitudes  

V_letter = np.array([[i.value for i in j] for j in ws_vertices['B5':'DV5']]) 
XX = np.zeros(length_V, dtype=object)
for i in range(len(XX)):
    XX[i] = V_letter[0,i]
V_letter = XX #Vertex first letters

V_pop = np.array([[i.value for i in j] for j in ws_vertices['B6':'DV6']]) 
XX = np.zeros(length_V, dtype=object)
for i in range(len(XX)):
    XX[i] = V_pop[0,i]
V_pop = XX #Vertex population

#------------------------------------------------------------------------------

# Load edge characteristics

#load set of edges
E = np.array([[i.value for i in j] for j in ws_edges['B2':'DV126']])

#load core cities geography data
doc_name           =    "\#Core_cities_geography.xlsx"
wb_core_geography  =    load_workbook(loading_path_string+""+doc_name)

# Loading distance by road between city centres
ws_road_distances  =    wb_core_geography['Distance_road']
DS_road            =    np.array([[i.value for i in j] for j in ws_road_distances['F6':'DZ130']], dtype=float)       

# Loading duration by road between city centres 
ws_road_duration   =    wb_core_geography['Duration_road']
DUR_road           =    np.array([[i.value for i in j] for j in ws_road_duration['F6':'DZ130']], dtype=float)

# Loading duration by road between city centres 
ws_road_duration   =    wb_core_geography['Duration_air_access']
DUR_air_access     =    np.array([[i.value for i in j] for j in ws_road_duration['F6':'DZ130']], dtype=float)

# Loading duration by road between city centres 
ws_road_duration   =    wb_core_geography['Duration_air_invehicle']
DUR_air_invehicle  =    np.array([[i.value for i in j] for j in ws_road_duration['F6':'DZ130']], dtype=float)

# Loading duration by road between city centres 
ws_road_duration   =    wb_core_geography['Duration_air_egress']
DUR_air_egress     =    np.array([[i.value for i in j] for j in ws_road_duration['F6':'DZ130']], dtype=float)
#------------------------------------------------------------------------------

# Load demand characteristics

DM = np.array([[i.value for i in j] for j in ws_demand['B2':'DV126']]) #load demand

#------------------------------------------------------------------------------

#remove Dublin from lists and matrices (city 54)

#reduce vertex list
V           = np.delete(V,        54)
V_lat       = np.delete(V_lat,    54)
V_lon       = np.delete(V_lon,    54)
V_letter    = np.delete(V_letter ,54)
V_pop       = np.delete(V_pop,    54)

#reduce edge matrix
E           = np.delete(E,   54,   axis=0)
E           = np.delete(E,   54,   axis=1)

#reduce edge matrix
DS_road     = np.delete(DS_road,   54,   axis=0)
DS_road     = np.delete(DS_road,   54,   axis=1)

#reduce edge matrix
DUR_road    = np.delete(DUR_road,   54,   axis=0)
DUR_road    = np.delete(DUR_road,   54,   axis=1)

#reduce flight time data
DUR_air_access    = np.delete(DUR_air_access,   54,   axis=0)
DUR_air_access    = np.delete(DUR_air_access,   54,   axis=1)

DUR_air_invehicle    = np.delete(DUR_air_invehicle,   54,   axis=0)
DUR_air_invehicle    = np.delete(DUR_air_invehicle,   54,   axis=1)

DUR_air_egress    = np.delete(DUR_air_egress,   54,   axis=0)
DUR_air_egress    = np.delete(DUR_air_egress,   54,   axis=1)

#reduce demand matrix
DM          = np.delete(DM,   54,   axis=0)
DM          = np.delete(DM,   54,   axis=1)

#recal new length for V 
length_V    = copy.deepcopy(len(V))
range_len_V = copy.deepcopy(range(length_V))

#------------------------------------------------------------------------------

# Load mode characteristics

M = np.array([[i.value for i in j] for j in ws_modes['B1':'D1']]) 
XX = np.zeros(len(M[0]), dtype=object)
for i in range(len(XX)):
    XX[i] = M[0,i]
M = XX #set of modes

s_crs = np.array([[i.value for i in j] for j in ws_modes['B2':'D2']])
XX = np.zeros(len(M))
for i in range(len(XX)):
    XX[i] = s_crs[0,i]
s_crs = XX #mode speeds

cap_seat = np.array([[i.value for i in j] for j in ws_modes['B3':'D3']])
XX = np.zeros(len(M))
for i in range(len(XX)):
    XX[i] = cap_seat[0,i]
cap_seat = XX #mode capacities

fac_dt = np.array([[i.value for i in j] for j in ws_modes['B7':'D7']]) 
XX = np.zeros(len(M))
for i in range(len(XX)):
    XX[i] = fac_dt[0,i]
fac_dt = XX #mode detour factor

t_dwl = np.array([[i.value for i in j] for j in ws_modes['B8':'D8']])
XX = np.zeros(len(M))
for i in range(len(XX)):
    XX[i] = t_dwl[0,i]
t_dwl = XX #mode dwelling time

t_acc = np.array([[i.value for i in j] for j in ws_modes['B9':'D9']])
XX = np.zeros(len(M))
for i in range(len(XX)):
    XX[i] = t_acc[0,i]
t_acc = XX #mode acceleration time

ds_acc = np.array([[i.value for i in j] for j in ws_modes['B10':'D10']])
XX = np.zeros(len(M))
for i in range(len(XX)):
    XX[i] = ds_acc[0,i]
ds_acc = XX #mode acceleration distance

t_dec = np.array([[i.value for i in j] for j in ws_modes['B11':'D11']])
XX = np.zeros(len(M))
for i in range(len(XX)):
    XX[i] = t_dec[0,i]
t_dec = XX #mode deceleration time

ds_dec = np.array([[i.value for i in j] for j in ws_modes['B12':'D12']])
XX = np.zeros(len(M))
for i in range(len(XX)):
    XX[i] = ds_dec[0,i]
ds_dec = XX #mode deceleration distance

fac_load = np.array([[i.value for i in j] for j in ws_modes['B13':'D13']])
XX = np.zeros(len(M))
for i in range(len(XX)):
    XX[i] = fac_load[0,i]
fac_load = XX #mode deceleration distance

t_access = np.array([[i.value for i in j] for j in ws_modes['B15':'D15']])
XX = np.zeros(len(M))
for i in range(len(XX)):
    XX[i] = t_access[0,i]
t_access = XX #mode speific access times

t_wait = np.array([[i.value for i in j] for j in ws_modes['B16':'D16']])
XX = np.zeros(len(M))
for i in range(len(XX)):
    XX[i] = t_wait[0,i]
t_wait = XX #mode speific waiting times

t_transfer = np.array([[i.value for i in j] for j in ws_modes['B17':'D17']])
XX = np.zeros(len(M))
for i in range(len(XX)):
    XX[i] = t_transfer[0,i]
t_transfer = XX #mode speific transfer times

t_egress = np.array([[i.value for i in j] for j in ws_modes['B18':'D18']])
XX = np.zeros(len(M))
for i in range(len(XX)):
    XX[i] = t_egress[0,i]
t_egress = XX #mode speific egress times

car_rest_factor = float(ws_modes['B24'].value)

TAT_hsr = ws_modes['C20'].value #turn around time HSR train

fac_ctngcy = ws_modes['C21'].value #contingency factor (delays, breakdowns, external damages, etc.)

h_oper_hsr = ws_modes['C22'].value #daily operational hours

strategic_pricing_level = 1.05 #concerning path detours induced by transfers
strategic_pricing_level_2 = 1.25 #concerning geographical detours on a path

#------------------------------------------------------------------------------

#greater circle distance calculation

from math import radians, cos, sin, asin, sqrt

def haversine(lat_i, lon_i, lat_j, lon_j):

    # convert decimal degrees to radians 
    lat_i, lon_i, lat_j, lon_j = map(radians, [lat_i, lon_i, lat_j, lon_j])

    # haversine formula 
    lat_delta = (lat_j - lat_i) 
    lon_delta = (lon_j - lon_i) 
    sr = sqrt(sin(lat_delta/2)**2 + cos(lat_i) * cos(lat_j) * sin(lon_delta/2)**2)
    R_earth = 6371.000 #radius earth [m]
    ds_gc = R_earth * 2 * asin(sr)
    return ds_gc #[km]

DS_gc = np.zeros((length_V,length_V)) #empty greater circle distance matrix
i=0 ; j=0
for i in range(length_V):
    for j in range_len_V:
        DS_gc[i,j] = haversine(V_lat[i],V_lon[i],V_lat[j],V_lon[j])
           
#------------------------------------------------------------------------------
        
#building modelled direct distance between city pairs
DS_land_direct = np.zeros((length_V, length_V),dtype=float)      
for i in range_len_V:
    for j in range_len_V:
        DS_land_direct[i,j] = DS_road[i,j] / fac_dt[2]

#------------------------------------------------------------------------------
        
#building distance by rail between city pairs
DS_rail = np.zeros((length_V, length_V),dtype=float)
for i in range_len_V:
    for j in range_len_V:
        DS_rail[i,j] = DS_road[i,j] / fac_dt[2] * fac_dt[1]
        
#------------------------------------------------------------------------------

#In-vehcile time calculation
        
def func_t_inv_air(i,j):
    
    t_inv_air = DUR_air_invehicle[i,j] #in-vehcile time per airplane edge
    
    return t_inv_air #in-vehicle time car [h]

def func_t_inv_hsr(ds_rail):
    
    t_inv_hsr = (t_dwl[1] / 2.) + t_acc[1] + (ds_rail - ds_acc[1] - ds_dec[1]) / (s_crs[1]) + t_dec[1] + (t_dwl[1] / 2.)  #in-vehcile time per HSR edge
    
    return t_inv_hsr #in-vehicle time car [h]

def func_t_inv_car(dur_road_ij):
    
    t_inv_car = dur_road_ij * car_rest_factor #in-vehcile time per car edge
    
    return t_inv_car #in-vehicle time car [h]


#------------------------------------------------------------------------------

#produce mode-specific edge in-vehicle time matrices

T_inv_air = np.zeros((length_V,length_V), dtype=float) #empty in-vehcile time matrix (air)    
for i in range_len_V:
    for j in range_len_V:
        T_inv_air[i,j] = float(copy.copy(func_t_inv_air(i,j))) #fill matrix      
            
T_inv_hsr = np.zeros((length_V,length_V)) #empty in-vehcile time matrix (hsr)
for i in range_len_V:
    for j in range_len_V:
        if E[i,j] == 1:
            T_inv_hsr[i,j] = copy.copy(func_t_inv_hsr(DS_rail[i,j])) #fill matrix

T_inv_car = np.zeros((length_V,length_V)) #empty in-vehcile time matrix (car)    
for i in range_len_V:
    for j in range_len_V:
        T_inv_car[i,j] = copy.copy(func_t_inv_car(DUR_road[i,j])) #fill matrix

#------------------------------------------------------------------------------
        
#determining HSR access/egress times
        
avg_population_density = 3000
pi = 3.1415926535898
average_city_speed = 30

def t_hsr_avg_accegr(V_population):
    
    radius = math.sqrt(V_population / avg_population_density / pi)
    average_accegr_duration = 0.5 * radius / 30
    
    return average_accegr_duration

T_hsr_accegr = np.zeros(length_V)
for i in range_len_V:
    T_hsr_accegr[i] = round(t_hsr_avg_accegr(V_pop[i]),3)


#------------------------------------------------------------------------------
        
def func_t_trip_air(i,j):

    t_trip_air = DUR_air_access[i,j] + t_wait[0] + T_inv_air[i,j] + DUR_air_egress[i,j] #no transfers needed

    return t_trip_air #[h]


def func_t_trip_hsr(i,j,t_path_inv_hsr, n_transfers):

    t_trip_hsr = T_hsr_accegr[i] + t_wait[1] + t_path_inv_hsr + n_transfers * t_transfer[1] + T_hsr_accegr[j]

    return t_trip_hsr #[h]

def func_t_trip_car(i,j):

    t_trip_car = t_access[2] + t_wait[2] + T_inv_car[i,j] + t_transfer[2] + t_egress[2]

    return t_trip_car #[h]
   
#------------------------------------------------------------------------------

#calculate relative weights for VoT
w_acc = VoT_access   /  VoT_invehicle 
w_wai = VoT_waiting  /  VoT_invehicle 
w_inv = 1.0
w_trf = VoT_transfer /  VoT_invehicle
w_egr = VoT_egress   /  VoT_invehicle


#calculate weighted travel times
def func_t_trip_air_weighted(i,j):

    t_trip_air = (DUR_air_access[i,j]*w_acc) + (t_wait[0]*w_wai) + (T_inv_air[i,j]*w_inv) + (DUR_air_egress[i,j]*w_egr) #no transfers needed

    return t_trip_air #[h]

def func_t_trip_hsr_weighted(i,j,t_path_inv_hsr, n_transfers):

    t_trip_hsr = (T_hsr_accegr[i] * w_acc) + (t_wait[1]*w_wai) + (t_path_inv_hsr*w_inv) + (n_transfers * t_transfer[1]*w_trf) + (T_hsr_accegr[j]*w_egr)

    return t_trip_hsr #[h]

def func_t_trip_car_weighted(i,j):

    t_trip_car = (T_inv_car[i,j]*w_inv)

    return t_trip_car #[h]

#------------------------------------------------------------------------------

#produce mode-specific total trip time matrices

T_trip_air = np.zeros((length_V,length_V)) #empty trip time matrix (air)
T_trip_air_weighted = np.zeros((length_V,length_V))
for i in range_len_V:
    for j in range_len_V:
        if i!= j:
            T_trip_air[i,j] = round(func_t_trip_air(i,j),2) #fill matrix
            T_trip_air_weighted[i,j] = round(func_t_trip_air_weighted(i,j),2)

#HSR is line configuration dependent, thus not here

T_trip_car = np.zeros((length_V,length_V)) #empty trip time matrix (air)  
T_trip_car_weighted = np.zeros((length_V,length_V))
for i in range_len_V:
    for j in range_len_V:
        if i!= j:
            T_trip_car[i,j] = round(func_t_trip_car(i,j),2) #fill matrix
            T_trip_car_weighted[i,j] = round(func_t_trip_car_weighted(i,j),2)
            

#------------------------------------------------------------------------------     
            
#Reduce the number of OD-pairs that have to be evaluated for HSR traffic

def MS_air_predictor(distance):
    
    if distance <= 200.:
        MS_air = float('inf')
    if distance > 200. and distance < 1300.:
        MS_air =((1.4940581931E-12*distance**4) - (4.7257341849021E-09*distance**3) + (4.59662481788692E-6*distance**2) - (5.0276000274593E-4*distance))
    if distance >= 1300.:
        MS_air = 1.00
    
    return MS_air

#------------------------------------------------------------------------------

#MS_HSR_predictor

def MS_HSR_predictor(distance):
    
    if distance <= 100.:
        MS_HSR = 0
    if distance > 100. and distance < 1500.:
        MS_HSR =((0.00000000006522360140*distance**4) - (0.00000009161463642984*distance**3) - (0.00008072041752767160*distance**2) + (0.11664607542751200000*distance))/100
    if distance >= 1500.:
        MS_HSR = 0
    
    return MS_HSR

#------------------------------------------------------------------------------

#count the total number of OD flows in the network
DM_existing_ODpair = np.zeros((length_V, length_V))
for i in range_len_V:
    for j in range_len_V:
        if DM[i,j] > 1:
            DM_existing_ODpair[i,j] = 1
no_of_OD_flows = np.sum(DM_existing_ODpair) / 2
print 'Total number of OD-pairs with demand', no_of_OD_flows
            
#count the number of OD flows that might consider to use HSR (5% < x > 95%)   
DM_HSR_feasible = np.zeros((length_V, length_V))
for i in range_len_V:
    for j in range_len_V:
        if DS_land_direct[i,j] > 200.0 and DS_land_direct[i,j] <2000:
            if DS_land_direct[i,j] < (strategic_pricing_level_2 * DS_gc[i,j]):
                DM_HSR_feasible[i,j] = 1  
no_of_ODpairs_within_HSR_range = np.sum(DM_HSR_feasible) / 2       
print 'Total number of OD-pairs relevant to HSR ( 5% < MS_hsr_exp > 95%)', no_of_ODpairs_within_HSR_range

#determine how many OD flows should be considered for next step
for i in range_len_V:
    for j in range_len_V:
        DM_HSR_feasible[i,j] = DM_HSR_feasible[i,j] * DM_existing_ODpair[i,j]
No_of_double_ODpairs = np.sum(DM_HSR_feasible) / 2
print 'Total number of OD-pairs relevant to HSR that have a demand', No_of_double_ODpairs

#determine the flows that create the largest passenger-kilometer values
list_of_OD_flows_corrected = list()
DM_hsr_estimated = np.zeros((length_V,length_V))
potential_total_demand_half_corrected = 0
no_pax_hsr_pot = 0
for i in range_len_V:
    for j in range_len_V:
        if DM[i,j]*DM_HSR_feasible[i,j] > 0:
            DM_hsr_estimated[i,j] = DM[i,j]*MS_HSR_predictor(DS_land_direct[i,j])*DS_land_direct[i,j]
            no_pax_hsr_pot = DM[i,j]*MS_HSR_predictor(DS_land_direct[i,j])
            list_of_OD_flows_corrected.append(DM_hsr_estimated[i,j])
            potential_total_demand_half_corrected = potential_total_demand_half_corrected + DM_hsr_estimated[i,j]
list_of_OD_flows_corrected.sort()
kick_off_rate = (100. - demand_resolution) / 100.
flow_sum = 0; OD_flow_threshold = 0; OD_flow_threshold_k = 0
for item in range(len(list_of_OD_flows_corrected)):
    flow_sum = flow_sum + list_of_OD_flows_corrected[item]
    if flow_sum < kick_off_rate*potential_total_demand_half_corrected:
        OD_flow_threshold = list_of_OD_flows_corrected[item]
        OD_flow_threshold_k = item
DM_flow_threshold = np.zeros((length_V, length_V))
for i in range_len_V:
    for j in range_len_V:
        if DM_hsr_estimated[i,j] > OD_flow_threshold:
            DM_flow_threshold[i,j] = 1 

#determine how many OD flows should be considered for next step
for i in range_len_V:
    for j in range_len_V:
        DM_HSR_feasible[i,j] = DM_HSR_feasible[i,j] * DM_existing_ODpair[i,j] * DM_flow_threshold[i,j]
No_of_double_ODpairs = np.sum(DM_HSR_feasible) / 2
print 'Total number of OD-pairs that are considered for HSR', No_of_double_ODpairs

for i in range_len_V:
    teller_hits = 0
    teller_dm = 0
    for j in range_len_V:
        teller_hits = teller_hits + DM_HSR_feasible[i,j]
        teller_dm = teller_dm + DM[i,j] * DM_HSR_feasible[i,j] * MS_HSR_predictor(DS_land_direct[i,j])
    print V[i], teller_hits, int(teller_dm)
    
    


#------------------------------------------------------------------------------     
            
            
'''

#network map projection

        
fig = plt.figure(figsize=(15,15)) #50,50
m = Basemap(projection='lcc', resolution='c',
            lon_0=12.5, lat_0=52, lat_1=40, lat_2=60, 
            width=4E6, height=3.5E6) #lon_0=12.5, lat_0=52, lat_1=40, lat_2=60, width=4E6, height=3.5E6)

m.drawcoastlines()
m.fillcontinents(color="#FFDDCC", lake_color='#DDEEFF')
m.drawmapboundary(fill_color="#DDEEFF")
m.drawcountries()

#add edges
for i in range_len_V:
    for j in range_len_V:
        if i != j:
            if i > j:
                if E[i,j] == 1:
                    m.drawgreatcircle(V_lon[i],V_lat[i],V_lon[j],V_lat[j],linewidth=3,color='#A5C100')

#add vertices     
for i in range_len_V: 
    x, y = m(V_lon[i], V_lat[i])
    plt.plot(x, y, 'ok', markersize=20, color='#00415F') #plt.plot(x, y, 'ok', markersize=20, color='#00415F') 
    plt.plot(x, y, 'ok', markersize=15, color='#007896') #plt.plot(x, y, 'ok', markersize=15, color='#007896')
    x, y = m(V_lon[i]-0.06, V_lat[i]-0.06)   # x, y = m(V_lon[i]-0.06, V_lat[i]-0.06)      
    plt.text(x, y, V_letter[i], fontsize=10, color='w'); #plt.text(x, y, V_letter[i], fontsize=10, color='w');
plt.show()
'''
#------------------------------------------------------------------------------

#used colour palette

cl_blue_dark      = ['#00567D' , '#00577e' ,'#80abbf' , '#bfd5df' , '#e6eef2' ]
cl_green_light    = ['#a5c100' , '#bcd140' ,'#d5d986' , '#eaecc2' , '#f7f7e7' ]
cl_blue_light     = ['#0086a8' , '#40a4be' ,'#80c3d4' , '#bfe1e9' , '#e6f3f6' ]
                 
cl_orange         = ['#f49600' , '#f39600' ,'#f9cb80' , '#fce5bf' , '#fef5e6' ]
cl_red            = ['#e41f18' , '#e31f18' ,'#f18f8c' , '#f8c7c5' , '#fce9e8' ]
cl_purple_bright  = ['#821066' , '#811066' ,'#c087b2' , '#e0c3d9' , '#f2e7f0' ]
cl_yellow         = ['#ffd923' , '#ffe26e' ,'#ffec91' , '#fff6c8' , '#fffbe9' ]
cl_green_dark     = ['#72981b' , '#72971b' ,'#b9cb8d' , '#dce5c5' , '#f1f5e8' ]
cl_purple_light   = ['#776db0' , '#978fc5' ,'#bbb6d7' , '#dddbeb' , '#f1f0f5' ]
cl_grey           = ['#686867' , '#696868' ,'#b4b4b3' , '#dad9d9' , '#f0f0f0' ]
cl_black          = ['#1d1d1b' , '#646363' ,'#9d9d9c' , '#d0d0d0' , '#ededed' ]

"""----------------------------------------------------------------------------
--------------------------------  OPERATION 1  --------------------------------
-----------------------  Distance-Based Shortest Paths  -----------------------
----------------------------------------------------------------------------"""

#------------------------------------------------------------------------------

time_begin_1 = time.time() #set sub-timer

#------------------------------------------------------------------------------

#Define Dijkstra Procedure
from collections import defaultdict, deque

class Graph(object):
    def __init__(self):
        self.nodes = set()
        self.edges = defaultdict(list)
        self.distances = {}

    def add_node(self, value):
        self.nodes.add(value)

    def add_edge(self, from_node, to_node, distance):
        self.edges[from_node].append(to_node)
        self.edges[to_node].append(from_node)
        self.distances[(from_node, to_node)] = distance

def dijkstra(graph, initial):
    visited = {initial: 0}
    path = {}

    nodes = set(graph.nodes)

    while nodes:
        min_node = None
        for node in nodes:
            if node in visited:
                if min_node is None:
                    min_node = node
                elif visited[node] < visited[min_node]:
                    min_node = node
        if min_node is None:
            break

        nodes.remove(min_node)
        current_weight = visited[min_node]

        for edge in graph.edges[min_node]:
            try:
                weight = current_weight + graph.distances[(min_node, edge)]
            except:
                continue
            if edge not in visited or weight < visited[edge]:
                visited[edge] = weight
                path[edge] = min_node

    return visited, path

def shortest_path(graph, origin, destination):
    visited, paths = dijkstra(graph, origin)
    full_path = deque()
    _destination = paths[destination]

    while _destination != origin:
        full_path.appendleft(_destination)
        _destination = paths[_destination]

    full_path.appendleft(origin)
    full_path.append(destination)

    return visited[destination], list(full_path)

#i=6 ; j=4
#print shortest_path(graph, V[i], V[j])

#------------------------------------------------------------------------------

#Perform Dijkstra for this graph (distance-based edge weights)
    
matrix_SP = np.zeros((length_V,length_V), dtype=object) #build empty matrix_SP

if __name__ == '__main__':
    graph = Graph()

    for node in V:
        graph.add_node(node)
        
    for i in range_len_V:
        for j in range_len_V:
            if E[i,j] == 1:
                graph.add_edge(V[i],V[j],T_inv_hsr[i,j])
                
    i=0 ; j=0 ; count_i = -1 ; count_j = -1

    for i in V:
        count_j = -1
        count_i = count_i + 1
        for j in V:
            count_j = count_j + 1
            if i != j:
                #print(shortest_path(graph, i, j))
                #result.append(shortest_path(graph, v[0,count_i], v[0,count_j]))
                matrix_SP[count_i,count_j] = shortest_path(graph, V[count_i], V[count_j])

max_range_limit = 18
matrix_range_limit = np.ones((length_V,length_V))
for i in range(length_V):
    for j in range(length_V):
        if i != j:
            if matrix_SP[i,j][0] > max_range_limit:
                matrix_range_limit[i,j] = 0  
                
#make a copy for later restorement of matrix SP                
matrix_PS = copy.deepcopy(matrix_SP)

"""----------------------------------------------------------------------------
--------------------------------  OPERATION 2  --------------------------------
---------------------------  Edge Usage Statistics  ---------------------------
----------------------------------------------------------------------------"""

#------------------------------------------------------------------------------

time_begin_2 = time.time() #set sub-timer

#------------------------------------------------------------------------------

#determine number of passenger on each edge

edge_volume = np.zeros((length_V,length_V))#empty edge volume matrix

for x in range_len_V:
    for y in range_len_V:
        if E[x,y] == 1:
            for i in range_len_V:
                for j in range_len_V:
                    if i != j:
                        for a in range(len(matrix_SP[i,j][1])):
                            if matrix_SP[i,j][1][a] == V[x]:
                                if a != len(matrix_SP[i,j][1])-1: 
                                    if matrix_SP[i,j][1][a+1] == V[y]:
                                        edge_volume[x,y] = edge_volume[x,y] + DM[i,j]
            
#print edge_volume

#------------------------------------------------------------------------------

#devide number of passenger by edge length 

edge_usage = np.zeros((length_V,length_V))#empty edge usage matrix

for i in range_len_V:
    for j in range_len_V:
        if E[i,j] == 1:
            edge_usage[i,j] = edge_volume[i,j] / T_inv_hsr[i,j]
            

#------------------------------------------------------------------------------

#normalise values

edge_usage_ave = np.zeros((length_V,length_V)) #empty edge usage matrix
edge_usage_norm = np.zeros((length_V,length_V)) #empty edge usage matrix

for i in range_len_V: #average values for both directions
    for j in range_len_V:
        if E[i,j] == 1:
            edge_usage_ave[i,j] = (edge_usage[i,j] + edge_usage[j,i]) / 2.0
            
for i in range_len_V: #normalise values to share fracture of whole
    for j in range_len_V:
        if E[i,j] == 1:
            edge_usage_norm[i,j] = edge_usage_ave[i,j] / np.sum(edge_usage_ave)            

max_use = np.max(edge_usage_norm)
#print edge_usage_norm

for i in range_len_V: #normalise values to from 0-1
    for j in range_len_V:
        if E[i,j] == 1:
            edge_usage_norm[i,j] = (edge_usage_norm[i,j] / max_use * 100.0)

#print edge_usage_norm

"""----------------------------------------------------------------------------
--------------------------------  OPERATION 3  --------------------------------
------------------------  Edge Weight Transformation  -------------------------
----------------------------------------------------------------------------"""

#------------------------------------------------------------------------------

time_begin_3 = time.time() #set sub-timer

#------------------------------------------------------------------------------

#normalise HSR edge in-vehicle times

T_inv_hsr_norm = np.zeros((length_V,length_V)) #empty normalised inv time matrix
max_t_inv_hsr = np.max(T_inv_hsr) #define longest i-v time edge

for i in range_len_V: #normalise values to from 0-1
    for j in range_len_V:
        if E[i,j] == 1:
            T_inv_hsr_norm[i,j] = (T_inv_hsr[i,j] / max_t_inv_hsr * 100.0)
#print T_inv_hsr
#print T_inv_hsr_norm

#------------------------------------------------------------------------------

#Calculated transformed edge weights

edge_trans = np.zeros((length_V,length_V))

for i in range_len_V: #normalise values to from 0-1
    for j in range_len_V:
        if E[i,j] == 1:
            edge_trans[i,j] = (edge_usage_norm[i,j] * fac_use_weight) + (T_inv_hsr_norm[i,j] * (1.0 - fac_use_weight))


#------------------------------------------------------------------------------

"""----------------------------------------------------------------------------
--------------------------------  OPERATION 4  --------------------------------
-------------------------  Demand-Based Path Finding  -------------------------
----------------------------------------------------------------------------"""

#------------------------------------------------------------------------------

time_begin_4 = time.time() #set sub-timer

#------------------------------------------------------------------------------

#Perform Dijkstra for this graph (demand-based edge weights)

matrix_DP = np.zeros((length_V,length_V), dtype=object) #build empty matrix_SP

if __name__ == '__main__':
    graph = Graph()

    for node in V:
        graph.add_node(node)
        
    for i in range_len_V:
        for j in range_len_V:
            if E[i,j] == 1:
                graph.add_edge(V[i],V[j],edge_trans[i,j])
                
    i=0 ; j=0 ; count_i = -1 ; count_j = -1

    for i in V:
        count_j = -1
        count_i = count_i + 1
        for j in V:
            count_j = count_j + 1
            if i != j:
                #print(shortest_path(graph, i, j))
                #result.append(shortest_path(graph, v[0,count_i], v[0,count_j]))
                matrix_DP[count_i,count_j] = shortest_path(graph, V[count_i], V[count_j])

#print matrix_DP

#------------------------------------------------------------------------------

#Find actual travel times of new routes

def Vnum(a): #finds vertex index number
    return np.where(V==a)[0][0]

DP_true_length = np.zeros((length_V,length_V)) #empty true lenght matrix
a=0 #set a to zero
for i in range_len_V:
    for j in range_len_V:
        if i != j:         
            DP_path = list([matrix_DP[i,j][1][a]]) #define origin
            for a in range(len(matrix_DP[i,j][1])):
                if a != len(matrix_DP[i,j][1])-1:
                    DP_path.append(matrix_DP[i,j][1][a+1]) #append next stop
                    x = matrix_DP[i,j][1][a] #define edge start
                    y = matrix_DP[i,j][1][a+1] #define edge end
                    DP_true_length[i,j] = DP_true_length[i,j] + T_inv_hsr[Vnum(x), Vnum(y)]
            matrix_DP[i,j] = DP_true_length[i,j], list(DP_path) #adjust DP_matrix
            a = 0 #reset a value

#print matrix_DP
pool_of_lines_temp = (matrix_SP, matrix_DP)
#------------------------------------------------------------------------------

#create pre-pool of lines

pre_pool_of_lines = (matrix_SP, matrix_DP)

"""----------------------------------------------------------------------------
--------------------------------  OPERATION 5  --------------------------------
-----------------------------  Line Restriction  ------------------------------
----------------------------------------------------------------------------"""

#------------------------------------------------------------------------------

time_begin_5 = time.time() #set sub-timer

#------------------------------------------------------------------------------
                
#Constraint: Line Symmetry

import sys  #import stopping code execution

a=0
for matrix_X in pre_pool_of_lines: #for all line matrices
    for i in range_len_V: #for all OD-pairs
        for j in range_len_V:
            if i != j: #not the 0's diagonal
                if i < j: #only matrix lower half
                    if matrix_X[i,j] != 0:
                        for a in range(len(matrix_X[i,j][1])-1):
                            if matrix_X[i,j][1][a] != matrix_X[j,i][1][len(matrix_X[i,j][1])-1-a]:
                                sys.exit('ALERT: NOT ALL LINES ARE SYMMETRICAL')

#------------------------------------------------------------------------------

#Exclude identical lines from matrix_DP

for i in range_len_V:
    for j in range_len_V:
        if i != j:
            if i > j:
                if matrix_SP[i,j][1] == matrix_DP[i,j][1]:
                    matrix_DP[i,j] = 0; matrix_DP[j,i] = 0
        
#------------------------------------------------------------------------------                    
                    
#Count number of lines before constraints
                            
n_lines = 0 #number of lines

for matrix_X in pre_pool_of_lines: #for all line matrices
    for i in range_len_V: #for all OD-pairs
        for j in range_len_V:
            if i != j: #not the 0's diagonal
                    if i > j: #only matrix lower half
                        if matrix_X[i,j] != 0:
                            n_lines = n_lines + 1

n_lines_uncs = n_lines                            

#------------------------------------------------------------------------------

#Constraint: Minimum line length constraint
                    
min_len = ws_UDP['C9'].value #minimum lenght of line
             
for matrix_X in pre_pool_of_lines: #for all line matrices
    xpath_true_distance = np.zeros((length_V,length_V)) #empty path length matrix
    a=0 #set a to zero
    for i in range_len_V: #for all OD-pairs
        for j in range_len_V:
            if i != j:
                if i > j:
                    if matrix_X[i,j] != 0:
                        X_path = list([matrix_X[i,j][1][a]]) #define origin
                        for a in range(len(matrix_X[i,j][1])):
                            if a != len(matrix_X[i,j][1])-1:
                                X_path.append(matrix_X[i,j][1][a+1]) #append next stop
                                x = matrix_X[i,j][1][a] #define edge start
                                y = matrix_X[i,j][1][a+1] #define edge end
                                xpath_true_distance[i,j] = xpath_true_distance[i,j] + DS_rail[Vnum(x), Vnum(y)]
                        if xpath_true_distance[i,j] < min_len:
                            matrix_X[i,j] = 0; matrix_X[j,i] = 0
                        a = 0 #reset a value

#------------------------------------------------------------------------------                

#Constraint: Minimum Number of Stops
    
min_stops = ws_UDP['C10'].value #minimum number of stops per line

for matrix_X in pre_pool_of_lines: #for all line matrices
    for i in range_len_V: #for all OD-pairs
        for j in range_len_V:
            if i != j: #not the 0 diagonal
                if i > j: #only matrix lower half
                    if matrix_X[i,j] != 0:
                        if len(matrix_X[i,j][1]) < min_stops:
                            matrix_X[i,j] = 0 ; matrix_X[j,i] = 0
                            
#------------------------------------------------------------------------------
                
#Constraint: Round Trip Time

max_time_time = ws_UDP['C11'].value #maximum daily time single-way trip

for matrix_X in pre_pool_of_lines: #for all line matrices
    for i in range_len_V: #for all OD-pairs
        for j in range_len_V:
            if i != j: #not the 0's diagonal
                if i > j: #only matrix lower half
                    if matrix_X[i,j] != 0:
                        if matrix_X[i,j][0] > ( max_time_time / 2 ) - TAT_hsr:
                            matrix_X[i,j] = 0 ; matrix_X[j,i] = 0   

  
              
#------------------------------------------------------------------------------

#Constraint: maximum detour constraint
                    
allowed_detour_A = 1.5 #between summed rail distance and direct land distance of begin and end station
             
for matrix_X in pre_pool_of_lines: #for all line matrices
    xpath_true_distance = np.zeros((length_V,length_V)) #empty path length matrix
    a=0 #set a to zero
    for i in range_len_V: #for all OD-pairs
        for j in range_len_V:
            if i != j:
                if i > j:
                    if matrix_X[i,j] != 0:
                        X_path = list([matrix_X[i,j][1][a]]) #define origin
                        for a in range(len(matrix_X[i,j][1])):
                            if a != len(matrix_X[i,j][1])-1:
                                X_path.append(matrix_X[i,j][1][a+1]) #append next stop
                                x = matrix_X[i,j][1][a] #define edge start
                                y = matrix_X[i,j][1][a+1] #define edge end
                                xpath_true_distance[i,j] = xpath_true_distance[i,j] + DS_rail[Vnum(x), Vnum(y)]
                        if xpath_true_distance[i,j] > allowed_detour_A * fac_dt[1] * DS_land_direct[i,j]:
                            matrix_X[i,j] = 0; matrix_X[j,i] = 0
                        a = 0 #reset a value

#------------------------------------------------------------------------------

#Constraint: maximum detour constraint
                    
allowed_detour_B = 99 #between summed rail distance and direct land distance of begin and end station
             
for matrix_X in pre_pool_of_lines: #for all line matrices
    for i in range_len_V: #for all OD-pairs
        for j in range_len_V:
            if i != j:
                if i > j:
                    if matrix_X[i,j] != 0:
                        if DS_land_direct[i,j] > DS_gc[i,j] * allowed_detour_B:
                            matrix_X[i,j] = 0; matrix_X[j,i] = 0
                        a = 0 #reset a value

pre_pool_of_lines_back_up = copy.deepcopy(pre_pool_of_lines)
#------------------------------------------------------------------------------                
                
#Constraint: only terminal cities


terminal_cities = set(('TIRA','VIEN','MINS','BRUS','SARA',
                      'SOFI','ZAGR','PRAG','COPE','TALL',
                      'HELS','PARI','BERL','ATHE','BUDA',
                      'ROME','PRIS','RIGA','LUXE','SKOP',
                      'CHIS','PODG','OSLO','WARS','LISB',
                      'BUCH','MOSC','BELG','BRAT','LJUB',
                      'MADR','STOC','ZURI','AMST','ANKA',
                      'KIEV','LOND','GLAS','PORT','CATA',
                      'MUNI','BARC','SEVI','RUHR','STUT',
                      'FRAN','MANC','BORD','ISTA','LYON')) #37 + 10

list_of_terminal_cities = ['TIRA','VIEN','MINS','BRUS','SARA',
                      'SOFI','ZAGR','PRAG','COPE','TALL',
                      'HELS','PARI','BERL','ATHE','BUDA',
                      'ROME','PRIS','RIGA','LUXE','SKOP',
                      'CHIS','PODG','OSLO','WARS','LISB',
                      'BUCH','MOSC','BELG','BRAT','LJUB',
                      'MADR','STOC','ZURI','AMST','ANKA',
                      'KIEV','LOND','GLAS','PORT','CATA',
                      'MUNI','BARC','SEVI','RUHR','STUT',
                      'FRAN','MANC','BORD','ISTA','LYON'] #37 + 10


#delete all non-terminal city pairs
for matrix_X in pre_pool_of_lines: #for all line matrices
    for i in range_len_V: #for all OD-pairs
        for j in range_len_V:
            if i != j: #not the 0's diagonal
                if i > j: #only matrix lower half
                    if matrix_X[i,j] != 0:
                        if matrix_X[i,j][1][0] not in terminal_cities or matrix_X[i,j][1][len(matrix_X[i,j][1])-1] not in terminal_cities:
                            matrix_X[i,j] = 0 ; matrix_X[j,i] = 0 
                                                        
#------------------------------------------------------------------------------
                            
#restoring matrix_SP by the use of an old copy
matrix_SP = copy.copy(matrix_PS)              

#------------------------------------------------------------------------------     
          
#Count number of lines after constraints 
                            
n_lines = 0 #number of lines

for matrix_X in pre_pool_of_lines: #for all line matrices
    for i in range_len_V: #for all OD-pairs
        for j in range_len_V:
            if i != j: #not the 0's diagonal
                    if i > j: #only matrix lower half
                        if matrix_X[i,j] != 0:
                            n_lines = n_lines + 1
                            
n_lines_cons = n_lines #count the number of lines after constraints    
                           
#------------------------------------------------------------------------------
                            
#Construct Pool of lines       
                     
POOL_OF_LINES = np.zeros((n_lines,7),dtype=object) #active, rfe, ij, ji, ds_tot, n_stops, t_inv_tot

line_counter = 0

for matrix_X in pre_pool_of_lines: #for all line matrices
    xpath_true_distance = np.zeros((length_V,length_V)) #empty path length matrix
    a=0
    for i in range_len_V: #for all od pairs
        for j in range_len_V:
            if i != j: #not the 0's diagonal
                    if i > j: #only matrix lower half
                        if matrix_X[i,j] != 0:
                            POOL_OF_LINES[line_counter,0] = 1 #active or not
                            POOL_OF_LINES[line_counter,1] = 0 #frequency
                            POOL_OF_LINES[line_counter,2] = matrix_X[i,j][1] #line i to j
                            POOL_OF_LINES[line_counter,3] = matrix_X[j,i][1] #line j to i
                            X_path = list([matrix_X[i,j][1][a]]) #calculate total distance of a path
                            for a in range(len(matrix_X[i,j][1])):
                                if a != len(matrix_X[i,j][1])-1:
                                    X_path.append(matrix_X[i,j][1][a+1]) 
                                    x = matrix_X[i,j][1][a]
                                    y = matrix_X[i,j][1][a+1] 
                                    xpath_true_distance[i,j] = xpath_true_distance[i,j] + DS_rail[Vnum(x), Vnum(y)]
                            POOL_OF_LINES[line_counter,4] = xpath_true_distance[i,j] #ds_tot
                            POOL_OF_LINES[line_counter,5] = len(matrix_X[i,j][1]) #n_stops
                            POOL_OF_LINES[line_counter,6] = matrix_X[j,i][0] #t_inv_tot
                            a = 0 #reset a value
                            line_counter = line_counter +1


#save POOL_OF_LINES
df = pd.DataFrame(POOL_OF_LINES)
doc_name     =    "/POOL_OF_LINES.xlsx"
df.to_excel(excel_writer = saving_path_string+""+doc_name)
                    
#------------------------------------------------------------------------------
#print edge_usage_norm
#print edge_trans

#Make selection within the POOL_OF_LINES
SELECTED_POOL_OF_LINES = copy.deepcopy(POOL_OF_LINES)

#set all lines to be inactive
for line in range(len(SELECTED_POOL_OF_LINES)):
    SELECTED_POOL_OF_LINES[line,0] = 0 #active or not

#Determine which lines end and begin at the terminal stations
for city in list_of_terminal_cities:
    
    #define number of lines that are selected
    k_closeby = k_closeby_OV
    k_large_hsr_demand = k_large_hsr_demand_OV
    k_usage_route = k_usage_route_OV

    list_of_relevant_lines = list()
    for line in range(len(SELECTED_POOL_OF_LINES)):
        if SELECTED_POOL_OF_LINES[line,2][0] == city or SELECTED_POOL_OF_LINES[line,3][0] == city:
            list_of_relevant_lines.append(line) 
    
    #if the vertex does not have enough lines, adjust to minimum
    if len(list_of_relevant_lines) < k_closeby:
        k_closeby = len(list_of_relevant_lines)
    if len(list_of_relevant_lines) < k_large_hsr_demand:
        k_large_hsr_demand = len(list_of_relevant_lines)
    if len(list_of_relevant_lines) < k_usage_route:
        k_usage_route = len(list_of_relevant_lines)

    #selecteer de verbindingen naar de k dichtsbijzijnde andere key cities
    list_of_line_distances = np.zeros(len(list_of_relevant_lines), dtype = float)
    for linex in range(len(list_of_relevant_lines)):
        list_of_line_distances[linex] = SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],6]
    list_of_line_distances = np.sort(list_of_line_distances)
    threshold_value_low_distance = list_of_line_distances[k_closeby-1]
    for linex in range(len(list_of_relevant_lines)):
        if SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],6] <= threshold_value_low_distance + epsilon0:
            SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],0] = 1
           
    #selecteer de verbindingen naar de k grootste demand andere key cities
    list_of_line_ends_demand = np.zeros(len(list_of_relevant_lines), dtype = float)
    for linex in range(len(list_of_relevant_lines)):
        i = Vnum(SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],2][0])
        j = Vnum(SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],3][0])
        list_of_line_ends_demand[linex] = DM[i,j] * MS_HSR_predictor(DS_land_direct[i,j])
    list_of_line_ends_demand = np.sort(list_of_line_ends_demand)
    threshold_large_hsr_demand = list_of_line_ends_demand[len(list_of_line_ends_demand)-k_large_hsr_demand]
    for linex in range(len(list_of_relevant_lines)):
        i = Vnum(SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],2][0])
        j = Vnum(SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],3][0])
        if threshold_large_hsr_demand == 0:
            if DM[i,j] * MS_HSR_predictor(DS_land_direct[i,j]) > 0:
                SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],0] = 1 
        if threshold_large_hsr_demand > 0:
            if DM[i,j] * MS_HSR_predictor(DS_land_direct[i,j]) >= threshold_large_hsr_demand - epsilon0:
                SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],0] = 1
    
    #selecteer the lines with the highest number of utility passengers on their lines
    list_of_line_usage = np.zeros(len(list_of_relevant_lines), dtype = float)
    for linex in range(len(list_of_relevant_lines)):
        a=0
        X_path = list(SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],2][a]) #define origin
        for a in range(len(SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],2])):
            if a != len(SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],2])-1:
                X_path.append(SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],2][a+1]) 
                x = SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],2][a]
                y = SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],2][a+1]
                list_of_line_usage[linex] = list_of_line_usage[linex] + edge_usage_norm[Vnum(x),Vnum(y)]
    list_of_line_usage = np.sort(list_of_line_usage)
    threshold_usage_value = list_of_line_usage[len(list_of_line_usage)-k_usage_route]
    for linex in range(len(list_of_relevant_lines)):
        if threshold_usage_value == 0:
            if list_of_line_usage[linex] > 0:
                SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],0] = 1 
        if threshold_large_hsr_demand > 0:
            if list_of_line_usage[linex] >= threshold_usage_value - epsilon0:
                SELECTED_POOL_OF_LINES[list_of_relevant_lines[linex],0] = 1
            
#------------------------------------------------------------------------------

#delete non-activated lines from selected pool_of_lines
correction = 0
for row in range(len(SELECTED_POOL_OF_LINES)):
    if SELECTED_POOL_OF_LINES[row-correction,0] == 0:
        SELECTED_POOL_OF_LINES = np.delete(SELECTED_POOL_OF_LINES, [row-correction], axis=0)
        correction = correction+1

#save definitive POOL_OF_LINES
POOL_OF_LINES = copy.deepcopy(SELECTED_POOL_OF_LINES)

#------------------------------------------------------------------------------
        
#search for cities that are not connected yet

non_connected_cities = list()
count_city = 0
for i in range_len_V:
    count_city = 0
    for row in range(len(SELECTED_POOL_OF_LINES)):
        if SELECTED_POOL_OF_LINES[row,0] == 1:
            for x in range(len(SELECTED_POOL_OF_LINES[row,2])):
                if SELECTED_POOL_OF_LINES[row,2][x] == V[i]:
                    count_city = count_city + 1
    if count_city == 0:
        non_connected_cities.append(V[i])
        
connecting_selection = np.zeros((length_V, length_V),dtype=object)
for i in range_len_V: #for all OD-pairs
    if V[i] in non_connected_cities:
        list_of_connecting_options = list()
        for j in range_len_V:
            if V[j] in list_of_terminal_cities:
                 for matrix_X in pre_pool_of_lines_back_up: #for all line matrices
                     if matrix_X[i,j] != 0:
                         list_of_connecting_options.append(matrix_X[i,j])
        list_of_inv_times = list()
        for line in range(len(list_of_connecting_options)):
            list_of_inv_times.append(list_of_connecting_options[line][0])
        list_of_inv_times.sort()
        threshold_connecting_distance = list_of_inv_times[k_connecting_OV-1]
        connecting_line_selection = np.zeros(k_connecting_OV, dtype=object)
        counter = 0
        for line in range(len(list_of_connecting_options)):
            if list_of_connecting_options[line][0] < threshold_connecting_distance + epsilon0:
                connecting_line_selection[counter] = list_of_connecting_options[line]
                counter = counter + 1
        for liney in range(len(connecting_line_selection)):
            city_i = Vnum(connecting_line_selection[liney][1][0])
            city_j = Vnum(connecting_line_selection[liney][1][len(connecting_line_selection[liney][1])-1])
            connecting_selection[city_i, city_j] = 1; connecting_selection[city_j, city_i] = 1

for i in range_len_V:
    for j in range_len_V:
        if connecting_selection[i,j] == 1:
            connecting_selection[i,j] = pre_pool_of_lines_back_up[0][i,j]
alt_pre_pool_of_lines = (connecting_selection, np.zeros((length_V,length_V)))

n_lines_alt = 0
for matrix_X in alt_pre_pool_of_lines: #for all line matrices
    for i in range_len_V: #for all OD-pairs
        for j in range_len_V:
            if i != j: #not the 0's diagonal
                    if i > j: #only matrix lower half
                        if matrix_X[i,j] != 0:
                            n_lines_alt = n_lines_alt + 1
                            
#------------------------------------------------------------------------------

#Construct alternative Pool of lines for connecting lines
                     
ALT_POOL_OF_LINES = np.zeros((n_lines_alt,7),dtype=object) #active, rfe, ij, ji, ds_tot, n_stops, t_inv_tot
line_counter = 0
for matrix_X in alt_pre_pool_of_lines: #for all line matrices
    xpath_true_distance = np.zeros((length_V,length_V)) #empty path length matrix
    a=0
    for i in range_len_V: #for all od pairs
        for j in range_len_V:
            if i != j: #not the 0's diagonal
                    if i > j: #only matrix lower half
                        if matrix_X[i,j] != 0:
                            ALT_POOL_OF_LINES[line_counter,0] = 1 #active or not
                            ALT_POOL_OF_LINES[line_counter,1] = 0 #frequency
                            ALT_POOL_OF_LINES[line_counter,2] = matrix_X[i,j][1] #line i to j
                            ALT_POOL_OF_LINES[line_counter,3] = matrix_X[j,i][1] #line j to i
                            X_path = list([matrix_X[i,j][1][a]]) #calculate total distance of a path
                            for a in range(len(matrix_X[i,j][1])):
                                if a != len(matrix_X[i,j][1])-1:
                                    X_path.append(matrix_X[i,j][1][a+1]) 
                                    x = matrix_X[i,j][1][a]
                                    y = matrix_X[i,j][1][a+1] 
                                    xpath_true_distance[i,j] = xpath_true_distance[i,j] + DS_rail[Vnum(x), Vnum(y)]
                            ALT_POOL_OF_LINES[line_counter,4] = xpath_true_distance[i,j] #ds_tot
                            ALT_POOL_OF_LINES[line_counter,5] = len(matrix_X[i,j][1]) #n_stops
                            ALT_POOL_OF_LINES[line_counter,6] = matrix_X[j,i][0] #t_inv_tot
                            a = 0 #reset a value
                            line_counter = line_counter +1                

#append the alternative pool_of_lines to the actual pool_of_lines
POOL_OF_LINES = np.append(POOL_OF_LINES, ALT_POOL_OF_LINES, axis=0)
#------------------------------------------------------------------------------     

#Count total number of lines that are selected 
n_lines = len(POOL_OF_LINES)

#count the number of lines after constraints 
n_lines_selected = n_lines    
                           
#------------------------------------------------------------------------------
  
#save POOL_OF_LINES
df = pd.DataFrame(POOL_OF_LINES)
doc_name     =    "/POOL_OF_LINES2.xlsx"
df.to_excel(excel_writer = saving_path_string+""+doc_name)          

#-----------------------------------------------------------------------------

"""----------------------------------------------------------------------------
-------------------------------  CHAPTER NAP  ---------------------------------
------------------------  NETWORK ANALYSIS PROCEDURE  -------------------------
----------------------------------------------------------------------------"""

#-----------------------------------------------------------------------------

#definition of repetative functions

#-----------------------------------------------------------------------------

#modal split calculation (random regret based)

def func_modalsplit(tt_air,tt_hsr,tt_car): #find mode specific regret values

    if tt_air == float('inf') and tt_hsr == float('inf'):
        P_air = 0.0
        P_hsr = 0.0
        P_car = 1.0
    else:
        #Regret value determination
        R_air = np.log(1.0 + math.e**(-0.01 * 60 * (tt_hsr - tt_air))) + np.log(1.0 + math.e**(-0.01 * 60 * (tt_car - tt_air))) - np.log(2)
        R_hsr = np.log(1.0 + math.e**(-0.01 * 60 * (tt_air - tt_hsr))) + np.log(1.0 + math.e**(-0.01 * 60 * (tt_car - tt_hsr))) - np.log(2)
        R_car = np.log(1.0 + math.e**(-0.01 * 60 * (tt_air - tt_car))) + np.log(1.0 + math.e**(-0.01 * 60 * (tt_hsr - tt_car))) - np.log(2)
        #Mode probability determination
        P_air = math.e**(-R_air) / (math.e**(-R_air) + math.e**(-R_hsr) + math.e**(-R_car))
        P_hsr = math.e**(-R_hsr) / (math.e**(-R_air) + math.e**(-R_hsr) + math.e**(-R_car))
        P_car = math.e**(-R_car) / (math.e**(-R_air) + math.e**(-R_hsr) + math.e**(-R_car))
        
    return P_air, P_hsr, P_car
    

#-----------------------------------------------------------------------------

#zero transfer path minimum inv time identification

def func_t_inv_hsr_min_t0(set_of_paths_t0):
    path_matrix = np.zeros((len(set_of_paths_t0),5), dtype=object)#reconstruct array for further calculations
    for e in range(len(path_matrix)):
        for f in range(len(path_matrix[0])):
            path_matrix[e,f] = set_of_paths_t0[e][f]
    t_min_path_inv_hsr = np.min(path_matrix[:,4]) #determine minimum travel time path HSR
    
    return t_min_path_inv_hsr
    
#------------------------------------------------------------------------------
   
#one transfer path minimum inv time identification

def func_t_inv_hsr_min_t1(set_of_paths_t1):
    path_matrix = np.zeros((len(set_of_paths_t1),10), dtype=object)#reconstruct array for further calculations
    for e in range(len(path_matrix)):
        for f in range(len(path_matrix[0])):
            path_matrix[e,f] = set_of_paths_t1[e][f]
    t_min_path_inv_hsr_t1 = np.min(path_matrix[:,9]) #determine minimum travel time path HSR
    
    return t_min_path_inv_hsr_t1

#------------------------------------------------------------------------------
   
#connector path minimum inv time identification

def func_t_inv_hsr_min_cnct(set_of_paths_cnct):
    path_matrix = np.zeros((len(set_of_paths_cnct),8), dtype=object)#reconstruct array for further calculations
    for e in range(len(path_matrix)):
        for f in range(len(path_matrix[0])):
            path_matrix[e,f] = set_of_paths_cnct[e][f]
    t_min_path_inv_hsr_cnct = np.min(path_matrix[:,6]) #determine minimum travel time path HSR
    
    return t_min_path_inv_hsr_cnct
    
#------------------------------------------------------------------------------

#calculation travel time per mode

def func_tt_tot(i,j,n_transfers, t_min_path_inv_hsr):
    tt_air = T_trip_air[Vnum(V[i]),Vnum(V[j])]
    tt_hsr = func_t_trip_hsr(i,j,t_min_path_inv_hsr, n_transfers)
    tt_car = T_trip_car[Vnum(V[i]),Vnum(V[j])]
    
    return tt_air, tt_hsr, tt_car

#------------------------------------------------------------------------------
    
#calculation weighted travel time per mode

def func_tt_tot_weighted(i,j,n_transfers, t_min_path_inv_hsr):
    tt_air_w = T_trip_air_weighted[Vnum(V[i]),Vnum(V[j])]
    tt_hsr_w = func_t_trip_hsr_weighted(i,j,t_min_path_inv_hsr, n_transfers)
    tt_car_w = T_trip_car_weighted[Vnum(V[i]),Vnum(V[j])]
    
    return tt_air_w, tt_hsr_w, tt_car_w

#------------------------------------------------------------------------------

#define frequency determination formuala

def func_req_freq(Q_max):
    
    f_lk = math.ceil((Q_max) / (cap_seat[1] * fac_load[1]))
    
    return f_lk

#------------------------------------------------------------------------------

#Definition of user cost function

def func_C_user(c_access, c_waiting, c_invehicle, c_transfer, c_egress):
    
    C_user = c_access + c_waiting + c_invehicle + c_transfer + c_egress 
    
    return C_user

#------------------------------------------------------------------------------

#Definition of operator cost function

def func_C_operator(c_RSa, c_RSo, c_RSm):
    
    C_operator = c_RSa + c_RSo + c_RSm
    
    return C_operator

  
#------------------------------------------------------------------------------
        
#Definition of operator cost function

def func_C_external(c_external):
    
    C_external = c_external
    
    return C_external

#------------------------------------------------------------------------------
      
#Definition of objective function

def func_objective_function(PSI_user, C_user, PSI_operator, C_operator, PSI_external, C_external):
    
    Z = (PSI_user * C_user) + (PSI_operator * C_operator) + (PSI_external * C_external)
    
    return Z
    
#------------------------------------------------------------------------------

Best_path_history = np.zeros((length_V, length_V, 3, 80))


def NETWORK_ANALYSIS_PROCEDURE(N_proposed):
    global counter_NAP
    counter_NAP = counter_NAP + 1
    
    """----------------------------------------------------------------------------
    ---------------------------------  Stage A  -----------------------------------
    --------------------------  Trip demand assignment  ---------------------------
    ----------------------------------------------------------------------------"""
    
    #------------------------------------------------------------------------------
    
    #empty demand assignment matrices
    demand_asgmt_air = np.zeros((length_V, length_V))
    demand_asgmt_hsr = np.zeros((length_V, length_V, len(POOL_OF_LINES)))
    demand_asgmt_car = np.zeros((length_V, length_V))
    DM_air = 0;     DM_hsr = 0;     DM_car = 0
    
    #------------------------------------------------------------------------------
    
    #hsr path information storage
    best_path_hsr_matrix = np.zeros((length_V, length_V,3)) #0=n_trf ; 1=inv_time ; 2=actu.dis 
    
    #------------------------------------------------------------------------------

    #create place to store parent paths
    if NAP_reduced == 'false':
        matrix_of_paths_t0 = np.zeros((length_V,length_V), dtype=object)
        matrix_of_paths_t1 = np.zeros((length_V,length_V), dtype=object)
        matrix_of_paths_t2 = np.zeros((length_V,length_V), dtype=object)
        for i in range_len_V:
            for j in range_len_V:
                matrix_of_paths_t0[i,j] = []
                matrix_of_paths_t1[i,j] = []
                matrix_of_paths_t2[i,j] = []
      
    #start path search for city pair i-j
    for i in range_len_V:
        for j in range_len_V:
            #Restraining the number of necessary calculations
            if j < i: #only lower half of OD matrix (because symmetry)
                if matrix_range_limit[i,j] == 1 and DM_HSR_feasible[i,j]==1: #check if OD-pair is within daily passenger travel limit       
                    #if A_parent[2][i,j][1]  != 0: #check if OD-pair was still feasible in last parent 
                    #je kan hier iets doen dat ie mag reducen als de hoeveelheid paden kleiner zijn dan in de histolog? / nap reduced
                    
                    #reset storage of paths
                    set_of_paths_t0  = (([])); t0_path_available = 'false';  fast_path_time_t0 = float('inf')
                    set_of_paths_t1  = (([])); t1_path_available = 'false';  fast_path_time_t1 = float('inf')
                    set_of_paths_t2  = (([])); t2_path_available = 'false';  fast_path_time_t2 = float('inf')
                
                    #search for a direct path
                    for k in range(len(POOL_OF_LINES[:,2])): #for all lines k lines
                        if N_proposed[0][k] == 1:
                            for a in range(len(POOL_OF_LINES[:,2][k])): #for all stops of the line - search origin (direction alpha)
                                if POOL_OF_LINES[:,2][k][a] == V[i]:
                                    for b in range((len(POOL_OF_LINES[:,2][k])-1-a)): #for all remaining stops - search destination 
                                        if POOL_OF_LINES[:,2][k][b+a+1] == V[j]:
                                            originx = a; destinationx = a+b+1    
                                            path_time_inv = 0
                                            path_distance = 0
                                            for c in range(destinationx-originx):
                                                path_time_inv = path_time_inv + T_inv_hsr[Vnum(POOL_OF_LINES[:,2][k][originx+c]), Vnum(POOL_OF_LINES[:,2][k][originx+c+1])]
                                                path_distance = path_distance + fac_dt[1] * DS_gc[Vnum(POOL_OF_LINES[:,2][k][originx+c]), Vnum(POOL_OF_LINES[:,2][k][originx+c+1])]
                                            if path_time_inv < (strategic_pricing_level * matrix_SP[i,j][0]):
                                                set_of_paths_t0.append([k, 'alpha', originx, destinationx, path_time_inv, path_distance])
                                            if NAP_reduced == 'false' and path_time_inv < (strategic_pricing_level * matrix_SP[i,j][0]):
                                                matrix_of_paths_t0[i,j].append([k, 'alpha', originx, destinationx, path_time_inv, path_distance])
                            for a in range(len(POOL_OF_LINES[:,3][k])): #for all stops of the line search - origin (direction beta)
                                if POOL_OF_LINES[:,3][k][a] == V[i]:
                                    for b in range((len(POOL_OF_LINES[:,3][k])-1-a)): #for all remaining stops 0 search destination 
                                        if POOL_OF_LINES[:,3][k][b+a+1] == V[j]:
                                            originx = a; destinationx = a+b+1    
                                            path_time_inv = 0
                                            path_distance = 0
                                            for c in range(destinationx-originx):
                                                path_time_inv = path_time_inv + T_inv_hsr[Vnum(POOL_OF_LINES[:,3][k][originx+c]), Vnum(POOL_OF_LINES[:,3][k][originx+c+1])]
                                                path_distance = path_distance + fac_dt[1] * DS_gc[Vnum(POOL_OF_LINES[:,3][k][originx+c]), Vnum(POOL_OF_LINES[:,3][k][originx+c+1])]
                                            if path_time_inv < (strategic_pricing_level * matrix_SP[i,j][0]):
                                                set_of_paths_t0.append([k, 'beta', originx, destinationx, path_time_inv, path_distance])
                                            if NAP_reduced == 'false' and path_time_inv < (strategic_pricing_level * matrix_SP[i,j][0]):
                                                matrix_of_paths_t0[i,j].append([k, 'beta', originx, destinationx, path_time_inv, path_distance])
                    
                    #store key data of direct path
                    if len(set_of_paths_t0) != 0:
                        t0_path_available = 'true'
                        fast_path_time_t0 = func_t_inv_hsr_min_t0(set_of_paths_t0)
                        
                    
                    #----------------------------------------------------------
    
                    #make inventory of lines connected to origin and destination stations
                    line_options_orig = (([])) ;   line_options_dest = (([]))

                    
                    if t0_path_available == 'false' or fast_path_time_t0 > (matrix_SP[i,j][0] + t_transfer[1]):
                        for k in range(len(POOL_OF_LINES[:,2])): #for all k lines
                            if N_proposed[0][k] == 1:
                                for a in range(len(POOL_OF_LINES[:,2][k])): #for all stops of the line - search origin
                                    if POOL_OF_LINES[:,2][k][a] == V[i]:
                                        line_options_orig.append([k, a, (len(POOL_OF_LINES[:,2][k]) -1) - a]) #line no., stop no. alpha, stop no. beta
                                            
                                for b in range(len(POOL_OF_LINES[:,2][k])): #for all stops of the line - search destination
                                    if POOL_OF_LINES[:,2][k][b] == V[j]:
                                        line_options_dest.append([k, b, (len(POOL_OF_LINES[:,2][k]) -1) - b]) #line no., stop no. alpha, stop no. beta
          
                    #----------------------------------------------------------
                    
                    #search 1-transfer path possibilities
                    if t0_path_available == 'false' or fast_path_time_t0 > (matrix_SP[i,j][0] + t_transfer[1]):
                        if len(line_options_orig) != 0 and len(line_options_dest) != 0:
                            line_option_T1 = (([])) #['V', 'k_ori', 'S_a', 'S_b', 'k_dest', 'S_a', 'S_b']
                            
                            #search for 'crossing' lines that are connected to one of the OD stations
                            for c in range(len(line_options_orig)):
                                for d in range(len(line_options_dest)):
                                    #print line_options_orig[c][0], line_options_dest[d][0]
                                    for ca in range(len(POOL_OF_LINES[:,2][line_options_orig[c][0]])): #in de lengte van de hoeveelheid stops op de origin lijn
                                        for db in range(len(POOL_OF_LINES[:,2][line_options_dest[d][0]])): #in de lengte van de hoeveelheid stops op de destination lijn 
                                            if POOL_OF_LINES[:,2][line_options_orig[c][0]][ca] == POOL_OF_LINES[:,2][line_options_dest[d][0]][db]:
                                                #print 'match!!!'
                                                line_option_T1 = ( [POOL_OF_LINES[:,2][line_options_orig[c][0]][ca], 
                                                                   line_options_orig[c][0], 
                                                                   ca,
                                                                   (len(POOL_OF_LINES[line_options_orig[c][0],2]) -1) - ca,
                                                                   line_options_dest[d][0],
                                                                   db,
                                                                   (len(POOL_OF_LINES[line_options_dest[d][0],2]) -1) - db] )
                                                
                                                #----------------------------------
                                                #search for in-vehicle time of specific transfer option
                                                
                                                #calulate first leg
                                                path_time_inv_L1 = 0; path_time_inv_L2 = 0; path_time_inv_test = 0
                                                path_distance_L1 = 0
                                                dir_L1 = 0; dir_L2 = 0 #direction
                                                s_o = float("nan") ; s_t1a = float("nan") ; s_t1b = float("nan") ; s_d = float("nan") ; 
                                                
                                                N_stages_L1 = copy.copy(line_option_T1[2] - line_options_orig[c][1])
                                                #print N_stages_L1
                                                
                                                if N_stages_L1 > 0:
                                                    dir_L1 = 'alpha'
                                                    s_o   = line_options_orig[c][1]
                                                    s_t1a = line_options_orig[c][1] + N_stages_L1
                                                else:
                                                    dir_L1 = 'beta'
                                                    s_o   = line_options_orig[c][2] 
                                                    s_t1a = line_options_orig[c][2] - N_stages_L1
                                            
                                                for stg in range(abs(N_stages_L1)):
                                                    if N_stages_L1 > 0:
                                                        #print 'count stage', POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]+stg], stg
                                                        path_time_inv_L1 = path_time_inv_L1 + T_inv_hsr[Vnum(POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]+stg]), Vnum(POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]+stg+1])]
                                                        path_distance_L1 = path_distance_L1 + fac_dt[1] * DS_gc[Vnum(POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]+stg]), Vnum(POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]+stg+1])]
                                                        #print 'alpha',  POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]+stg], 'to', POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]+stg+1], '(',T_inv_hsr[Vnum(POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]+stg]), Vnum(POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]+stg+1])],')'
                                                    if N_stages_L1 < 0:
                                                        path_time_inv_L1 = path_time_inv_L1 + T_inv_hsr[Vnum(POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]-stg]), Vnum(POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]-stg-1])]
                                                        path_distance_L1 = path_distance_L1 + fac_dt[1] * DS_gc[Vnum(POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]-stg]), Vnum(POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]-stg-1])]
                                                        #print 'beta', POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]-stg], 'to', POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]-stg-1], '(',T_inv_hsr[Vnum(POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]-stg]), Vnum(POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]-stg-1])],')'
                                                #print 'TOTAL LEG 1:', path_time_inv_L1
    
                                                #calulate second leg
                                                path_time_inv_L2 = 0
                                                path_distance_L2 = 0
                                                
                                                N_stages_L2 = copy.copy(line_option_T1[5] - line_options_dest[d][1])
                                                #print 'N_stages_L2', N_stages_L2
                                                
                                                if N_stages_L2 > 0:
                                                    dir_L2 = 'beta'
                                                    s_t1b = line_options_dest[d][2] - N_stages_L2
                                                    s_d   = line_options_dest[d][2]  
                                                else:
                                                    dir_L2 = 'alpha'
                                                    s_t1b = line_options_dest[d][1] + N_stages_L2
                                                    s_d   = line_options_dest[d][1] 
                                                
                                                for stg in range(abs(N_stages_L2)):
                                                    if N_stages_L2 > 0:
                                                        #print 'count stage', POOL_OF_LINES[line_option_T1[1],2][line_options_orig[c][1]-stg], stg
                                                        path_time_inv_L2 = path_time_inv_L2 + T_inv_hsr[Vnum(POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]+stg]), Vnum(POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]+stg+1])]
                                                        path_distance_L1 = path_distance_L1 + fac_dt[1] * DS_gc[Vnum(POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]+stg]), Vnum(POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]+stg+1])]
                                                        #print 'beta', POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]+stg], 'to', POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]+stg+1], '(',T_inv_hsr[Vnum(POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]+stg]), Vnum(POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]+stg+1])],')'
                                                    if N_stages_L2 < 0:
                                                        path_time_inv_L2 = path_time_inv_L2 + T_inv_hsr[Vnum(POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]-stg]), Vnum(POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]-stg-1])]
                                                        path_distance_L1 = path_distance_L1 + fac_dt[1] * DS_gc[Vnum(POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]-stg]), Vnum(POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]-stg-1])]
                                                        #print 'alpha' , POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]-stg], 'to', POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]-stg-1], '(',T_inv_hsr[Vnum(POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]-stg]), Vnum(POOL_OF_LINES[line_option_T1[4],2][line_options_dest[d][1]-stg-1])],')'
                                                
                                                #print 'TOTAL LEG 2:', path_time_inv_L2
                                                path_time_inv_test = path_time_inv_L1 + path_time_inv_L2
                                                path_distance_test = path_distance_L1 + path_distance_L2
                                                #print 'TOTAL invehicle time:', path_time_inv_L1 + path_time_inv_L2
                                                if path_time_inv_test < (strategic_pricing_level * matrix_SP[i,j][0]):
                                                    set_of_paths_t1.append([POOL_OF_LINES[:,2][line_options_orig[c][0]][ca], line_options_orig[c][0] ,dir_L1, s_o, s_t1a, line_options_dest[d][0], dir_L2, s_t1b, s_d, path_time_inv_test, path_distance_test]) #(V_transfer, 'L1','a/b', 's_o', 's_t', 'L2', 'a/b', 's_t', 's_d', t_inv, 'dis' )
                                                if NAP_reduced == 'false' and path_time_inv_test < (strategic_pricing_level * matrix_SP[i,j][0]):
                                                    matrix_of_paths_t1[i,j].append([POOL_OF_LINES[:,2][line_options_orig[c][0]][ca], line_options_orig[c][0] ,dir_L1, s_o, s_t1a, line_options_dest[d][0], dir_L2, s_t1b, s_d, path_time_inv_test, path_distance_test])
                        
                    #store key data of 1-transfer path
                    if len(set_of_paths_t1) != 0:
                        t1_path_available = 'true'
                        fast_path_time_t1 = func_t_inv_hsr_min_t1(set_of_paths_t1)

        #------------------------------------------------------------------------------
        
                    #define which path-type is fastest
                    t0_ideal = 'false' ; t1_ideal = 'false' ; t2_ideal = 'false' ; uns_path = 'false'
                    
                    if   ( t0_path_available == 'true' ) and ( fast_path_time_t0 < fast_path_time_t1 + t_transfer[1] ) and ( fast_path_time_t0 < fast_path_time_t2 + 2*t_transfer[1] ):
                        t0_ideal = 'true'
                    elif ( t1_path_available == 'true' ) and ( fast_path_time_t1 + t_transfer[1] < fast_path_time_t0 ) and ( fast_path_time_t1 + t_transfer[1] < fast_path_time_t2 + 2*t_transfer[1] ):
                        t1_ideal = 'true'
                    elif ( t2_path_available == 'true' ) and ( fast_path_time_t2 + 2*t_transfer[1] < fast_path_time_t0 ) and ( fast_path_time_t2 + 2*t_transfer[1] < fast_path_time_t1 + t_transfer[1] ):
                        t2_ideal = 'true'
                    else:
                        uns_path = 'true'
                    #print t0_ideal, t1_ideal, t2_ideal, uns_path
                    #np.min(fast_path_time_t1, fast_path_time_t2, fast_path_time_t2)
         
        #------------------------------------------------------------------------------           
                    #traffic assignment procedure, if direct paths are found
                    if t0_ideal == 'true':
                        
                        #define number of transfers
                        n_trf_hsr = 0 
                        best_path_hsr_matrix[i,j][0] = n_trf_hsr ; best_path_hsr_matrix[j,i][0] = n_trf_hsr
                        
                        # determine minumum in-vehcile (from HSR paths)
                        t_min_path_inv_hsr = func_t_inv_hsr_min_t0(set_of_paths_t0)
                        best_path_hsr_matrix[i,j][1] = t_min_path_inv_hsr; best_path_hsr_matrix[j,i][1] = t_min_path_inv_hsr
                        
                        #determine associated path distance (from HSR paths)
                        while best_path_hsr_matrix[i,j][2] == 0:
                            for g in range(len(set_of_paths_t0)):
                                if set_of_paths_t0[g][4] < t_min_path_inv_hsr + epsilon0:
                                    best_path_hsr_matrix[i,j][2] = set_of_paths_t0[g][5]
                                    best_path_hsr_matrix[j,i][2] = set_of_paths_t0[g][5]
                                    
                        #determine minumum total travel time all modes               
                        tt_air = func_tt_tot_weighted(i,j,n_trf_hsr,t_min_path_inv_hsr)[0]
                        tt_hsr = func_tt_tot_weighted(i,j,n_trf_hsr,t_min_path_inv_hsr)[1]
                        tt_car = func_tt_tot_weighted(i,j,n_trf_hsr,t_min_path_inv_hsr)[2]
                        
                        #determine modal split for each mode
                        P_air = func_modalsplit(tt_air,tt_hsr,tt_car)[0]
                        P_hsr = func_modalsplit(tt_air,tt_hsr,tt_car)[1]
                        P_car = func_modalsplit(tt_air,tt_hsr,tt_car)[2]
                        
                        #Assign demand to car and air connections
                        demand_asgmt_air[i,j] = P_air * DM[i,j]
                        demand_asgmt_car[i,j] = P_car * DM[i,j]
                        #Define the number of equal performing HSR line options
                        count_n_equal_paths = 0
                        for g in range(len(set_of_paths_t0)):
                            if set_of_paths_t0[g][4] < t_min_path_inv_hsr + epsilon0:
                                count_n_equal_paths = count_n_equal_paths + 1
                        #assign demand to HSR line segments of all best line options
                        for g in range(len(set_of_paths_t0)): #for the number of zero transfer lines
                            if set_of_paths_t0[g][4] < t_min_path_inv_hsr + epsilon0: #if the line has the shortest time 
                                if set_of_paths_t0[g][1] == 'alpha': #define direction of line
                                    for h in range(set_of_paths_t0[g][3]-set_of_paths_t0[g][2]): #for the number of edges travelled
                                        x = Vnum(POOL_OF_LINES[set_of_paths_t0[g][0]][2][set_of_paths_t0[g][2] + h])
                                        y = Vnum(POOL_OF_LINES[set_of_paths_t0[g][0]][2][set_of_paths_t0[g][2] + h + 1])
                                        demand_asgmt_hsr[x,y, set_of_paths_t0[g][0]] = demand_asgmt_hsr[x,y, set_of_paths_t0[g][0]] + (DM[i,j]*P_hsr) / (count_n_equal_paths)
                                        #demand_asgmt_hsr[y,x, set_of_paths_t0[g][0]] = demand_asgmt_hsr[y,x, set_of_paths_t0[g][0]] + (DM[j,i]*P_hsr) / (count_n_equal_paths) 
                                if set_of_paths_t0[g][1] == 'beta': #define direction of line
                                    for h in range(set_of_paths_t0[g][3]-set_of_paths_t0[g][2]): #for the number of edges travelled    
                                        x = Vnum(POOL_OF_LINES[set_of_paths_t0[g][0]][3][set_of_paths_t0[g][2] + h])
                                        y = Vnum(POOL_OF_LINES[set_of_paths_t0[g][0]][3][set_of_paths_t0[g][2] + h + 1])
                                        demand_asgmt_hsr[x,y, set_of_paths_t0[g][0]] = demand_asgmt_hsr[x,y, set_of_paths_t0[g][0]] + (DM[i,j]*P_hsr) / (count_n_equal_paths)   
                                        #demand_asgmt_hsr[y,x, set_of_paths_t0[g][0]] = demand_asgmt_hsr[y,x, set_of_paths_t0[g][0]] + (DM[j,i]*P_hsr) / (count_n_equal_paths)
                                
        
        #-----------------------------------------------------------------------------
                                            
        
                    #traffic assignment procedure, if T1 paths are found
                    if t1_ideal == 'true':
                        #define number of transfers
                        n_trf_hsr = 1 
                        best_path_hsr_matrix[i,j][0] = n_trf_hsr ; best_path_hsr_matrix[j,i][0] = n_trf_hsr
                        
                        #determine minumum in-vehcile (from HSR paths)
                        t_min_path_inv_hsr = func_t_inv_hsr_min_t1(set_of_paths_t1)
                        best_path_hsr_matrix[i,j][1] = t_min_path_inv_hsr ; best_path_hsr_matrix[j,i][1] = t_min_path_inv_hsr
                        
                        #determine associated path distance (from HSR paths)
                        while best_path_hsr_matrix[i,j][2] == 0:
                            for g in range(len(set_of_paths_t1)):
                                if set_of_paths_t1[g][9] < t_min_path_inv_hsr + epsilon0:
                                    best_path_hsr_matrix[i,j][2] = set_of_paths_t1[g][10]
                                    best_path_hsr_matrix[j,i][2] = set_of_paths_t1[g][10]
                        
                        #determine minumum total travel time all modes               
                        tt_air = func_tt_tot_weighted(i,j,n_trf_hsr,t_min_path_inv_hsr)[0]
                        tt_hsr = func_tt_tot_weighted(i,j,n_trf_hsr,t_min_path_inv_hsr)[1]
                        tt_car = func_tt_tot_weighted(i,j,n_trf_hsr,t_min_path_inv_hsr)[2]
                        
                        #determine modal split for each mode
                        P_air = func_modalsplit(tt_air,tt_hsr,tt_car)[0]
                        P_hsr = func_modalsplit(tt_air,tt_hsr,tt_car)[1]
                        P_car = func_modalsplit(tt_air,tt_hsr,tt_car)[2]
                        
                        #Assign demand to car and air connections
                        demand_asgmt_air[i,j] = P_air * DM[i,j]
                        demand_asgmt_car[i,j] = P_car * DM[i,j]
                        
                        #Define the number of equal performing HSR line options
                        count_n_equal_paths = 0
                        for g in range(len(set_of_paths_t1)):
                            if set_of_paths_t1[g][9] < t_min_path_inv_hsr + epsilon0:
                                count_n_equal_paths = count_n_equal_paths + 1
                                              
                        #assign demand to HSR line segments of all best line options
                        for g in range(len(set_of_paths_t1)): #for the number of one transfer lines
                            if set_of_paths_t1[g][9] < t_min_path_inv_hsr + epsilon0: #if the line has the shortest time 
                                
                                #assign demand leg 1
                                if set_of_paths_t1[g][2] == 'alpha': #define direction of line
                                    for h in range(set_of_paths_t1[g][4]-set_of_paths_t1[g][3]): #for the number of edges travelled
                                        x = Vnum(POOL_OF_LINES[set_of_paths_t1[g][1]][2][set_of_paths_t1[g][3] + h])
                                        y = Vnum(POOL_OF_LINES[set_of_paths_t1[g][1]][2][set_of_paths_t1[g][3] + h + 1])
                                        demand_asgmt_hsr[x,y, set_of_paths_t1[g][1]] = demand_asgmt_hsr[x,y, set_of_paths_t1[g][1]] + (DM[i,j]*P_hsr) / (count_n_equal_paths) 
                                        #demand_asgmt_hsr[y,x, set_of_paths_t1[g][1]] = demand_asgmt_hsr[y,x, set_of_paths_t1[g][1]] + (DM[j,i]*P_hsr) / (count_n_equal_paths) 
                                if set_of_paths_t1[g][2] == 'beta': #define direction of line
                                    for h in range(set_of_paths_t1[g][4]-set_of_paths_t1[g][3]): #for the number of edges travelled    
                                        x = Vnum(POOL_OF_LINES[set_of_paths_t1[g][1]][3][set_of_paths_t1[g][3] + h])
                                        y = Vnum(POOL_OF_LINES[set_of_paths_t1[g][1]][3][set_of_paths_t1[g][3] + h + 1])
                                        demand_asgmt_hsr[x,y, set_of_paths_t1[g][1]] = demand_asgmt_hsr[x,y, set_of_paths_t1[g][1]] + (DM[i,j]*P_hsr) / (count_n_equal_paths)
                                        #demand_asgmt_hsr[y,x, set_of_paths_t1[g][1]] = demand_asgmt_hsr[y,x, set_of_paths_t1[g][1]] + (DM[j,i]*P_hsr) / (count_n_equal_paths) 
                                        
                                #assign demand leg 2
                                if set_of_paths_t1[g][6] == 'alpha': #define direction of line
                                    for h in range(set_of_paths_t1[g][8]-set_of_paths_t1[g][7]): #for the number of edges travelled
                                        x = Vnum(POOL_OF_LINES[set_of_paths_t1[g][5]][2][set_of_paths_t1[g][7] + h])
                                        y = Vnum(POOL_OF_LINES[set_of_paths_t1[g][5]][2][set_of_paths_t1[g][7] + h + 1])
                                        demand_asgmt_hsr[x,y, set_of_paths_t1[g][5]] = demand_asgmt_hsr[x,y, set_of_paths_t1[g][5]] + (DM[i,j]*P_hsr) / (count_n_equal_paths)
                                        #demand_asgmt_hsr[y,x, set_of_paths_t1[g][5]] = demand_asgmt_hsr[y,x, set_of_paths_t1[g][5]] + (DM[j,i]*P_hsr) / (count_n_equal_paths) 
                                if set_of_paths_t1[g][6] == 'beta': #define direction of line
                                    for h in range(set_of_paths_t1[g][8]-set_of_paths_t1[g][7]): #for the number of edges travelled    
                                        x = Vnum(POOL_OF_LINES[set_of_paths_t1[g][5]][3][set_of_paths_t1[g][7] + h])
                                        y = Vnum(POOL_OF_LINES[set_of_paths_t1[g][5]][3][set_of_paths_t1[g][7] + h + 1])
                                        demand_asgmt_hsr[x,y, set_of_paths_t1[g][5]] = demand_asgmt_hsr[x,y, set_of_paths_t1[g][5]] + (DM[i,j]*P_hsr) / (count_n_equal_paths)   
                                        #demand_asgmt_hsr[y,x, set_of_paths_t1[g][5]] = demand_asgmt_hsr[y,x, set_of_paths_t1[g][5]] + (DM[j,i]*P_hsr) / (count_n_equal_paths) 
                                          
        #------------------------------------------------------------------------------
         
                                
                            
                    #traffic assignment procedure, if T2 paths are found
                    if t2_ideal == 'true':
                        #define number of transfers
                        n_trf_hsr = 2 
                        best_path_hsr_matrix[i,j][0] = n_trf_hsr ; best_path_hsr_matrix[j,i][0] = n_trf_hsr
                        
                        #determine minumum in-vehcile (from HSR paths)
                        t_min_path_inv_hsr = min_value_T2_path
                        best_path_hsr_matrix[i,j][1] = t_min_path_inv_hsr ; best_path_hsr_matrix[j,i][1] = t_min_path_inv_hsr
                        
                        #determine associated path distance (from HSR paths)
                        best_path_hsr_matrix[i,j][2] = set_of_paths_t2[0][15] ; best_path_hsr_matrix[j,i][2] = set_of_paths_t2[0][15]
                        
                        #determine minumum total travel time all modes               
                        tt_air = func_tt_tot_weighted(i,j,n_trf_hsr,t_min_path_inv_hsr)[0]
                        tt_hsr = func_tt_tot_weighted(i,j,n_trf_hsr,t_min_path_inv_hsr)[1]
                        tt_car = func_tt_tot_weighted(i,j,n_trf_hsr,t_min_path_inv_hsr)[2]
                        
                        #determine modal split for each mode
                        P_air = func_modalsplit(tt_air,tt_hsr,tt_car)[0]
                        P_hsr = func_modalsplit(tt_air,tt_hsr,tt_car)[1]
                        P_car = func_modalsplit(tt_air,tt_hsr,tt_car)[2]
                        
                        #Assign demand to car and air connections
                        demand_asgmt_air[i,j] = P_air * DM[i,j]
                        demand_asgmt_car[i,j] = P_car * DM[i,j]
                        
                        #Define the number of equal performing HSR line options
                        count_n_equal_paths = len(set_of_paths_t2)               
                        #assign demand to HSR line segments of all best line options
                        for g in range(len(set_of_paths_t2)): #for the number of one transfer lines
                            
                            #assign demand leg 1 (feeder)
                            if set_of_paths_t2[g][3] == 'alpha': #define direction of line
                                for h in range(set_of_paths_t2[g][5]-set_of_paths_t2[g][4]): #for the number of edges travelled
                                    x = Vnum(POOL_OF_LINES[set_of_paths_t2[g][2]][2][set_of_paths_t2[g][4] + h])
                                    y = Vnum(POOL_OF_LINES[set_of_paths_t2[g][2]][2][set_of_paths_t2[g][4] + h + 1])
                                    demand_asgmt_hsr[x,y, set_of_paths_t2[g][2]] = demand_asgmt_hsr[x,y, set_of_paths_t2[g][2]] + (DM[i,j]*P_hsr) / (count_n_equal_paths) 
                                    #demand_asgmt_hsr[y,x, set_of_paths_t2[g][2]] = demand_asgmt_hsr[y,x, set_of_paths_t2[g][2]] + (DM[j,i]*P_hsr) / (count_n_equal_paths) 
                            if set_of_paths_t2[g][3] == 'beta': #define direction of line
                                for h in range(set_of_paths_t2[g][5]-set_of_paths_t2[g][4]): #for the number of edges travelled    
                                    x = Vnum(POOL_OF_LINES[set_of_paths_t2[g][2]][3][set_of_paths_t2[g][4] + h])
                                    y = Vnum(POOL_OF_LINES[set_of_paths_t2[g][2]][3][set_of_paths_t2[g][4] + h + 1])
                                    demand_asgmt_hsr[x,y, set_of_paths_t2[g][2]] = demand_asgmt_hsr[x,y, set_of_paths_t2[g][2]] + (DM[i,j]*P_hsr) / (count_n_equal_paths)
                                    #demand_asgmt_hsr[y,x, set_of_paths_t2[g][2]] = demand_asgmt_hsr[y,x, set_of_paths_t2[g][2]] + (DM[j,i]*P_hsr) / (count_n_equal_paths) 
                                    
                            #assign demand leg 2 (connector)
                            if set_of_paths_t2[g][7] == 'alpha': #define direction of line
                                for h in range(set_of_paths_t2[g][9]-set_of_paths_t2[g][8]): #for the number of edges travelled
                                    x = Vnum(POOL_OF_LINES[set_of_paths_t2[g][6]][2][set_of_paths_t2[g][8] + h])
                                    y = Vnum(POOL_OF_LINES[set_of_paths_t2[g][6]][2][set_of_paths_t2[g][8] + h + 1])
                                    demand_asgmt_hsr[x,y, set_of_paths_t2[g][6]] = demand_asgmt_hsr[x,y, set_of_paths_t2[g][6]] + (DM[i,j]*P_hsr) / (count_n_equal_paths) 
                                    #demand_asgmt_hsr[y,x, set_of_paths_t2[g][6]] = demand_asgmt_hsr[y,x, set_of_paths_t2[g][6]] + (DM[j,i]*P_hsr) / (count_n_equal_paths) 
                            if set_of_paths_t2[g][7] == 'beta': #define direction of line
                                for h in range(set_of_paths_t2[g][9]-set_of_paths_t2[g][8]): #for the number of edges travelled    
                                    x = Vnum(POOL_OF_LINES[set_of_paths_t2[g][6]][3][set_of_paths_t2[g][8] + h])
                                    y = Vnum(POOL_OF_LINES[set_of_paths_t2[g][6]][3][set_of_paths_t2[g][8] + h + 1])
                                    demand_asgmt_hsr[x,y, set_of_paths_t2[g][6]] = demand_asgmt_hsr[x,y, set_of_paths_t2[g][6]] + (DM[i,j]*P_hsr) / (count_n_equal_paths)
                                    #demand_asgmt_hsr[y,x, set_of_paths_t2[g][6]] = demand_asgmt_hsr[y,x, set_of_paths_t2[g][6]] + (DM[j,i]*P_hsr) / (count_n_equal_paths)
                                    
                            #assign demand leg 3 (receiver)
                            if set_of_paths_t2[g][11] == 'alpha': #define direction of line
                                for h in range(set_of_paths_t2[g][13]-set_of_paths_t2[g][12]): #for the number of edges travelled
                                    x = Vnum(POOL_OF_LINES[set_of_paths_t2[g][10]][2][set_of_paths_t2[g][12] + h])
                                    y = Vnum(POOL_OF_LINES[set_of_paths_t2[g][10]][2][set_of_paths_t2[g][12] + h + 1])
                                    demand_asgmt_hsr[x,y, set_of_paths_t2[g][10]] = demand_asgmt_hsr[x,y, set_of_paths_t2[g][10]] + (DM[i,j]*P_hsr) / (count_n_equal_paths)
                                    #demand_asgmt_hsr[y,x, set_of_paths_t2[g][10]] = demand_asgmt_hsr[y,x, set_of_paths_t2[g][10]] + (DM[j,i]*P_hsr) / (count_n_equal_paths)
                            if set_of_paths_t2[g][11] == 'beta': #define direction of line
                                for h in range(set_of_paths_t2[g][13]-set_of_paths_t2[g][12]): #for the number of edges travelled    
                                    x = Vnum(POOL_OF_LINES[set_of_paths_t2[g][10]][3][set_of_paths_t2[g][12] + h])
                                    y = Vnum(POOL_OF_LINES[set_of_paths_t2[g][10]][3][set_of_paths_t2[g][12] + h + 1])
                                    demand_asgmt_hsr[x,y, set_of_paths_t2[g][10]] = demand_asgmt_hsr[x,y, set_of_paths_t2[g][10]] + (DM[i,j]*P_hsr) / (count_n_equal_paths)
                                    #demand_asgmt_hsr[y,x, set_of_paths_t2[g][10]] = demand_asgmt_hsr[y,x, set_of_paths_t2[g][10]] + (DM[j,i]*P_hsr) / (count_n_equal_paths)
                        
            
                        
        #------------------------------------------------------------------------------
           
    
        #unsatisfied demand when no routes are found
                    
                    
                                         
                    if uns_path == 'true':
                                
                        #define number of transfers
                        n_trf_hsr = 0 
                        best_path_hsr_matrix[i,j][0]
                        # determine minumum in-vehcile (from HSR paths)
                        t_min_path_inv_hsr = 0
                        best_path_hsr_matrix[i,j][1] = t_min_path_inv_hsr ; best_path_hsr_matrix[j,i][1] = t_min_path_inv_hsr
                        #determine minumum total travel time all modes
                        tt_air = func_tt_tot_weighted(i,j,n_trf_hsr,t_min_path_inv_hsr)[0]
                        tt_hsr = float('inf')
                        tt_car = func_tt_tot_weighted(i,j,n_trf_hsr,t_min_path_inv_hsr)[2]

                        #determine modal split for each mode
                        P_air = func_modalsplit(tt_air,tt_hsr,tt_car)[0]
                        P_hsr = func_modalsplit(tt_air,tt_hsr,tt_car)[1]
                        P_car = func_modalsplit(tt_air,tt_hsr,tt_car)[2] 

                        #Assign demand to car and air connections
                        demand_asgmt_air[i,j] = P_air * DM[i,j]
                        demand_asgmt_car[i,j] = P_car * DM[i,j]
                        #print set_of_paths_t0

    #------------------------------------------------------------------------------
       

    #unsatisfied demand when not feasible for HSR (too far away or too low demand to consider)
                                                         
                else:
                    #define number of transfers
                    n_trf_hsr = 0
                    best_path_hsr_matrix[i,j][0]
                    # determine minumum in-vehcile (from HSR paths)
                    t_min_path_inv_hsr = 0
                    best_path_hsr_matrix[i,j][1] = t_min_path_inv_hsr ; best_path_hsr_matrix[j,i][1] = t_min_path_inv_hsr
                    #determine minumum total travel time all modes
                    tt_air = func_tt_tot_weighted(i,j,n_trf_hsr,t_min_path_inv_hsr)[0]
                    tt_hsr = float('inf')
                    tt_car = func_tt_tot_weighted (i,j,n_trf_hsr,t_min_path_inv_hsr)[2]

                    #determine modal split for each mode
                    P_air = func_modalsplit(tt_air,tt_hsr,tt_car)[0]
                    P_hsr = func_modalsplit(tt_air,tt_hsr,tt_car)[1]
                    P_car = func_modalsplit(tt_air,tt_hsr,tt_car)[2] 

                    #Assign demand to car and air connections
                    demand_asgmt_air[i,j] = P_air * DM[i,j]
                    demand_asgmt_car[i,j] = P_car * DM[i,j]

    #------------------------------------------------------------------------------

    #print 'inv. time from', V[6],'to',V[5], '=', best_path_hsr_matrix[6,5][1] , '(',best_path_hsr_matrix[6,5][0], ')'
    
    #print demand_asgmt_hsr[:,:,19]
    
    demand_asgmt_air_dummy = np.zeros((length_V, length_V))
    demand_asgmt_hsr_dummy = np.zeros((length_V, length_V, len(POOL_OF_LINES)))
    demand_asgmt_car_dummy = np.zeros((length_V, length_V))
    
    for i in range_len_V:
        for j in range_len_V:   
            demand_asgmt_air_dummy[i,j] = copy.copy(demand_asgmt_air[i,j]) + copy.copy(demand_asgmt_air[j,i])
            demand_asgmt_hsr_dummy[i,j] = copy.copy(demand_asgmt_hsr[i,j]) + copy.copy(demand_asgmt_hsr[j,i])
            demand_asgmt_car_dummy[i,j] = copy.copy(demand_asgmt_car[i,j]) + copy.copy(demand_asgmt_car[j,i])
            
    demand_asgmt_air = copy.copy(demand_asgmt_air_dummy)
    demand_asgmt_hsr = copy.copy(demand_asgmt_hsr_dummy)
    demand_asgmt_car = copy.copy(demand_asgmt_car_dummy)

    
        #create place to store parent paths
    if NAP_reduced == 'true':
        matrix_of_paths_t0 = None
        matrix_of_paths_t1 = None
        matrix_of_paths_t2 = None
            
        
    
    """----------------------------------------------------------------------------
    ---------------------------------  Stage B  -----------------------------------
    ----------------------  Line Frequency Determination  -------------------------
    ----------------------------------------------------------------------------"""
    
    #------------------------------------------------------------------------------
    
    #apply frequency formula on Line Configuration
    for k in range(n_lines):
        if N_proposed[0][k] == 1:
            Q_max = np.max(demand_asgmt_hsr[:,:,k])
            N_proposed[1][k] = func_req_freq(Q_max) #assign frequency to line

    #-----------------------------------------------------------------------------

    #apply minimum frequency constraint
    for k in range(n_lines):
        if N_proposed[0][k] == 1:
            if N_proposed[1][k] < 1:
                N_proposed[1][k] = 1
 
    #-----------------------------------------------------------------------------
    
    #integer frequncy is already accounted for in func_req_freq
                
    #frequency symmetry is already accounted for in func_req_freq
    
    #------------------------------------------------------------------------------
    
    """----------------------------------------------------------------------------
    ---------------------------------  Stage C  -----------------------------------
    ------------------------  Network Graph descriptor  ---------------------------
    ----------------------------------------------------------------------------"""
    
    #------------------------------------------------------------------------------
    
    #translate demand flows from edge specific to vertex specific
    
    DM_air = demand_asgmt_air
    
    DM_car = demand_asgmt_car
    
    DM_hsr = np.zeros((length_V,length_V))
    for i in range_len_V:
        for j in range_len_V:
            if i != j:
                DM_hsr[i,j] = DM[i,j] - DM_air[i,j] - DM_car[i,j]

    #output_tester = np.zeros((length_V, length_V))
    
    #for i in range_len_V:
     #   for j in range_len_V:
    #load demand flows into KPI's
    
    #N_proposed[2][5] = np.sum(DM_air) / np.sum(DM)
    #N_proposed[2][6] = np.sum(DM_hsr) / np.sum(DM)
    #N_proposed[2][7] = np.sum(DM_car) / np.sum(DM)
    
    #print np.sum(DM_air), np.sum(DM_hsr), np.sum(DM_car), '(',np.sum(DM),')'

    #------------------------------------------------------------------------------
    
    
    
    
    #------------------------------------------------------------------------------
    
    """----------------------------------------------------------------------------
    ---------------------------------  Stage D  -----------------------------------
    ---------------------  System Performance Computation  ------------------------
    ----------------------------------------------------------------------------"""
    
    #------------------------------------------------------------------------------
        
    #computation of access costs

    #define access passenger-hours for each mode
    t_acs_tot_air = np.sum(DM_air) * t_access[0]
    t_acs_tot_hsr = 0
    for i in range_len_V:
        for j in range_len_V:
            if i < j:
                t_acs_tot_hsr = t_acs_tot_hsr + DM_hsr[i,j]*T_hsr_accegr[i] + DM_hsr[j,i]*T_hsr_accegr[j]
    t_acs_tot_car = np.sum(DM_car) * t_access[2]
    
    #calculate total access costs
    c_access = VoT_access * (t_acs_tot_air + t_acs_tot_hsr + t_acs_tot_car)

    #------------------------------------------------------------------------------
        
    #computation of waiting time costs

    #define waiting passenger-hours for each mode
    t_wait_tot_air = np.sum(DM_air) * t_wait[0]
    t_wait_tot_hsr = np.sum(DM_hsr) * t_wait[1]
    t_wait_tot_car = np.sum(DM_car) * t_wait[2]
    
    #calculate total access costs
    c_waiting = VoT_waiting * (t_wait_tot_air + t_wait_tot_hsr + t_wait_tot_car)

    #------------------------------------------------------------------------------
        
    #computation of in-vehcile time costs

    #define invehcile passenger-hours for each mode
    t_inv_tot_air = 0 
    #print  DM_air[0,5]
    for i in range_len_V:
        for j in range_len_V:
            if i > j:
                if i != j:
                    if T_inv_air[i,j] != float('inf'):
                        t_inv_tot_air = t_inv_tot_air + T_inv_air[i,j] * DM_air[i,j] + T_inv_air[j,i] * DM_air[j,i]
                #if DM_air[i,j] != DM_air[j,i]:
                    #print 'alert!!', i, j 
    t_inv_tot_hsr = 0
    #print best_path_hsr_matrix[III,JJJ]
    for i in range_len_V:
        for j in range_len_V:
            if i > j:
                if i != j:
                    t_inv_tot_hsr = t_inv_tot_hsr + (best_path_hsr_matrix[i,j][1] * (DM_hsr[i,j] + DM_hsr[j,i]))
                    
    t_inv_tot_car = 0 
    #print DM_car[0,5]
    for i in range_len_V:
        for j in range_len_V:
            if i > j:
                if i != j:
                    t_inv_tot_car = t_inv_tot_car + T_inv_car[i,j] * DM_car[i,j] + T_inv_car[j,i] * DM_car[j,i] 
    #calculate total access costs   
    c_invehicle =  VoT_invehicle * (t_inv_tot_air + t_inv_tot_hsr + t_inv_tot_car)
    
    #------------------------------------------------------------------------------
        
    #computation of transfer time costs
    t_trf_tot_air = 0
    t_trf_tot_car = 0
    
    #define transfer passenger-hours for each mode
    t_trf_tot_hsr = 0
    for i in range_len_V:
        for j in range_len_V:
            if i > j:
                t_trf_tot_hsr = t_trf_tot_hsr + (t_transfer[1] * best_path_hsr_matrix[i,j][0] * (DM_hsr[i,j] + DM_hsr[j,i]))
    
    #calculate total transfer
    c_transfer = VoT_transfer * (t_trf_tot_hsr)
    #------------------------------------------------------------------------------
    
    #define egress passenger-hours for each mode
    t_egrs_tot_air = np.sum(DM_air) * t_egress[0]
    t_egrs_tot_hsr = 0
    for i in range_len_V:
        for j in range_len_V:
            if i < j:
                t_egrs_tot_hsr = t_egrs_tot_hsr + DM_hsr[i,j]*T_hsr_accegr[j] + DM_hsr[j,i]*T_hsr_accegr[i]
    t_egrs_tot_car = np.sum(DM_car) * t_egress[2]
    
    #calculate total access costs
    c_egress = VoT_egress * (t_egrs_tot_air + t_egrs_tot_hsr + t_egrs_tot_car)

    #------------------------------------------------------------------------------    
    
    #calculation of total user cost
    
    #Define relative point for fully active line set
    if NAP_empty == 'true':
        global C_use_prim; global c_acc_prim; global c_wai_prim; global c_inv_prim; global c_trf_prim; global c_egr_prim
        C_use_prim = copy.copy(func_C_user(c_access, c_waiting, c_invehicle, c_transfer, c_egress))
        c_acc_prim = copy.copy(c_access)
        c_wai_prim = copy.copy(c_waiting)
        c_inv_prim = copy.copy(c_invehicle)
        c_trf_prim = copy.copy(c_transfer)
        c_egr_prim = copy.copy(c_egress)
        
    #calculate actual relative external costs
    C_user = func_C_user(c_access, c_waiting, c_invehicle, c_transfer, c_egress) - C_use_prim
    
    #print round(C_user/1000.0,0), '' , round(c_access/1000.0,0), '' ,  round(c_waiting/1000.0,0), '' ,  round(c_invehicle/1000.0,0), '' ,  round(c_transfer/1000.0,0), '' ,  round(c_egress/1000.0,0), '' ,  round(C_use_prim/1000.0,0) 
    #------------------------------------------------------------------------------ 
    
    #calculation of total travel time
    tt_tot_air = t_acs_tot_air + t_wait_tot_air + t_inv_tot_air + t_trf_tot_air + t_egrs_tot_air
    tt_tot_hsr = t_acs_tot_hsr + t_wait_tot_hsr + t_inv_tot_hsr + t_trf_tot_hsr + t_egrs_tot_hsr
    tt_tot_car = t_acs_tot_car + t_wait_tot_car + t_inv_tot_car + t_trf_tot_car + t_egrs_tot_car
    
    #store in-vehicle times as KPIs    
    #N_proposed[2][8] = tt_tot_air               
    #N_proposed[2][9] = tt_tot_hsr   
    #N_proposed[2][10] = tt_tot_car
    #------------------------------------------------------------------------------ 
    
    #determine number of vehicles per line and in total 
       
    #vehicles per line and total
    n_veh_line = np.zeros((len(POOL_OF_LINES)))   
    n_veh_opr = 0 
    n_veh_tot = 0
    veh_daily_round_trips = np.zeros((len(POOL_OF_LINES)))
    
    for k in range(len(POOL_OF_LINES)):
        if N_proposed[0][k] == 1:
            #EEN DEEL HIERVAN KAN OOK VOORAF BEREKEND WORDEN
            time_round_trip = ( 2 * POOL_OF_LINES[k][6] ) + ( 2 * TAT_hsr )
            veh_daily_round_trips[k] = h_oper_hsr / time_round_trip 
            n_veh_line[k] = N_proposed[1][k] / veh_daily_round_trips[k] #freq / daily trips per vehicle
            n_veh_opr = n_veh_opr + n_veh_line[k] #sum vehicles per line
    
    n_veh_opr = n_veh_opr #number of operational vehicles (at any moment)
    n_veh_tot = math.ceil(n_veh_opr * fac_ctngcy) #multiply n_veh_opr with contingency factor

    #------------------------------------------------------------------------------ 
    
    #computation of rolling stock aquisition costs

    #parameters
    uc_acquisition_hsr_veh = 00000  #[unit costs per seat per annum]
    t_lifetime_hsr_veh = (40 * 365.25) #[days] (years * no of days per year)
    
    #caluculate total rolling stock aquisition costs
    c_RSa = n_veh_tot * (uc_acquisition_hsr_veh * cap_seat[1] / t_lifetime_hsr_veh )
    '''
    count_no_of_lines = 0
    for k in range(len(POOL_OF_LINES)):
        if N_proposed[0][k] == 1:
            count_no_of_lines = count_no_of_lines + 1     
    
    c_RSa = count_no_of_lines * 10000
    '''
    #------------------------------------------------------------------------------ 

    #computation of rolling stock operation costs (energy, staff etc.)
    
    #parameters
    #uc_operation_hsr_veh = 50000 #[unit costs per seat per annum]
    
    #caluculate total rolling stock operation costs
    #c_RSo = ( n_veh_opr * cap_seat[1] * ( uc_operation_hsr_veh / 365.25 ) )
    
    
    
    #------------------------------------------------------------------------------ 
        
    #computation of rolling stock maintenance costs

    #parameters
    uc_maintenance_hsr_veh = 0.0122 * 0.8 #[unit costs per seat per annum] (average campos)
    
    #computing the total distance travelled
    ds_RS_line = np.zeros((len(POOL_OF_LINES)))  #distance covered by rolling stock per line
    ds_per_veh = np.zeros((len(POOL_OF_LINES)))  
    ds_RS_tot = 0 #total distance covered by rolling stock
    
    for k in range(len(POOL_OF_LINES)):
        if N_proposed[0][k] == 1:
            ds_per_veh[k] = veh_daily_round_trips[k] * POOL_OF_LINES[k][4]
            ds_RS_line[k] = ds_per_veh[k] * n_veh_line[k]
            ds_RS_tot = ds_RS_tot + ds_RS_line[k] #total distance per day

    #caluculate total rolling stock maintenance costs
    c_RSm = ds_RS_tot * cap_seat[1] * uc_maintenance_hsr_veh
        
    
    #------
    uc_operation_hsr_veh = 0.130 * 0.8#[unit costs per seat per seat-km, see campos p25]
    #caluculate total rolling stock operation costs
    c_RSo = ds_RS_tot * cap_seat[1] * uc_operation_hsr_veh 

    #------------------------------------------------------------------------------ 
    
    #calculation of total operator costs
    
    C_operator = func_C_operator(c_RSa, c_RSo, c_RSm)
    
    #------------------------------------------------------------------------------ 
    #------------------------------------------------------------------------------ 
    
    #computation of external costs
        
    #parameters
    c_ext_pkm_air = 0.034 #external costs air passenger kilometer
    c_ext_pkm_hsr = 0.013 #external costs hsr passenger kilometer
    c_ext_pkm_car = 0.120 #external costs car passenger kilometer
    
    #total pax kilometers / RPK per mode
    RPK_air = 0 
    for i in range_len_V:
        for j in range_len_V:
            if i > j:
                RPK_air = RPK_air + DS_gc[i,j] * fac_dt[0] * DM_air[i,j] +  DS_gc[j,i] * fac_dt[0] * DM_air[j,i]
    c_ext_air = RPK_air * c_ext_pkm_air
    
    RPK_hsr = 0 
    for i in range_len_V:
        for j in range_len_V:
            if i > j:
                RPK_hsr = RPK_hsr + np.sum(demand_asgmt_hsr[i,j,:]) * DS_gc[i,j] * fac_dt[1] +np.sum(demand_asgmt_hsr[j,i,:]) * DS_gc[j,i] * fac_dt[1]
    c_ext_hsr = RPK_hsr * c_ext_pkm_hsr
    
    RPK_car = 0 
    for i in range_len_V:
        for j in range_len_V:
            if i > j:
                RPK_car = RPK_car + DS_gc[i,j] * fac_dt[2] * DM_car[i,j] + DS_gc[j,i] * fac_dt[2] * DM_car[j,i]
    c_ext_car = RPK_car * c_ext_pkm_car
    
    #calculate total external km costs
    c_external = c_ext_air + c_ext_hsr + c_ext_car
    
    #------------------------------------------------------------------------------
     
    #calculation of total external costs
    
    #Define relative point for fully active line set
    if NAP_empty == 'true':
        global C_ext_prim
        C_ext_prim = copy.copy(func_C_external(c_external))
    
   #calculate actual relative external costs
    C_external = func_C_external(c_external) - C_ext_prim
    
    #------------------------------------------------------------------------------ 
    #------------------------------------------------------------------------------ 
    
    #computation final opjective value
    Z = func_objective_function(PSI_user, C_user, PSI_operator, C_operator, PSI_external, C_external)
    
    #------------------------------------------------------------------------------
    #------------------------------------------------------------------------------
    
    #Loading results into neighbourhood log
    N_proposed[2][0] = Z
    N_proposed[2][1] = C_user
    N_proposed[2][2] = C_operator
    N_proposed[2][3] = C_external
    N_proposed[2][4]  = c_access
    N_proposed[2][5]  = c_waiting
    N_proposed[2][6]  = c_invehicle
    N_proposed[2][7]  = c_transfer
    N_proposed[2][8]  = c_egress
    N_proposed[2][9]  = c_RSo
    N_proposed[2][10] = c_RSm
    N_proposed[2][11] = np.sum(DM_air)
    N_proposed[2][12] = np.sum(DM_hsr)
    N_proposed[2][13] = np.sum(DM_car)
    N_proposed[2][14] = tt_tot_air
    N_proposed[2][15] = tt_tot_hsr
    N_proposed[2][16] = tt_tot_car
    
    #------------------------------------------------------------------------------
    
    #return final result of NAP
    return N_proposed, matrix_of_paths_t0, best_path_hsr_matrix, DM_air, DM_hsr, DM_car

    #------------------------------------------------------------------------------


#-----------------------------------------------------------------------------

"""----------------------------------------------------------------------------
------------------------  CHAPTER LINE CONFIGURATION  -------------------------
------------------------  NETWORK ANALYSIS PROCEDURE  -------------------------
----------------------------------------------------------------------------"""

#------------------------------------------------------------------------------

print '-----------------------------'
print 'Total number of generated lines', n_lines_uncs
print 'Number of terminal lines', len(list_of_terminal_cities) * len(list_of_terminal_cities)
print 'Number of feasible terminal lines', n_lines_uncs - n_lines_cons
print 'Total number of selected lines', n_lines_selected
print ''

#------------------------------------------------------------------------------

#Construction of Historical Log
n_KPIs = 17
HISTO_LOG = np.zeros((3), dtype=object)
HISTO_LOG[0] = np.zeros(n_lines) #Decision variable: active lines
HISTO_LOG[1] = np.zeros(n_lines) #Decision variable: frequencies
HISTO_LOG[2] = np.zeros(n_KPIs) #place for storage kpi's
#HISTO_LOG[3] = np.zeros((length_V, length_V))

#overview KPI storage

#HISTO_LOG[2][0]  = Z (objective function value)
#HISTO_LOG[2][1]  = C_user
#HISTO_LOG[2][2]  = C_operator
#HISTO_LOG[2][3]  = C_external
#HISTO_LOG[2][4]  = c_access
#HISTO_LOG[2][5]  = c_waiting
#HISTO_LOG[2][6]  = c_invehicle
#HISTO_LOG[2][7]  = c_transfer
#HISTO_LOG[2][8]  = c_egress
#HISTO_LOG[2][9]  = c_operation
#HISTO_LOG[2][10] = c_maintenance
#HISTO_LOG[2][11] = np.sum(DM_air)
#HISTO_LOG[2][12] = np.sum(DM_hsr)
#HISTO_LOG[2][13] = np.sum(DM_car)
#HISTO_LOG[2][14] = t_tt_tot_air
#HISTO_LOG[2][15] = t_tt_tot_hsr
#HISTO_LOG[2][16] = t_tt_tot_car
#HISTO_LOG[2][17] = 
#HISTO_LOG[2][18] = 
#HISTO_LOG[2][19] = 
#HISTO_LOG[2][20] = 
#HISTO_LOG[2][21] = 
#HISTO_LOG[2][22] = 
#HISTO_LOG[2][23] = 
#HISTO_LOG[2][24] = 
#HISTO_LOG[2][25] = 
#HISTO_LOG[2][26] = 
#HISTO_LOG[2][27] = 
#HISTO_LOG[2][28] = 
#HISTO_LOG[2][29] = 
#HISTO_LOG[2][30] = 
#HISTO_LOG[2][31] = 
#HISTO_LOG[2][32] = 




#------------------------------------------------------------------------------

#definition of repetative functions

#------------------------------------------------------------------------------

#OPERATION 6 (LINE ELIMINATION)

def OPERATION_6_LINE_ELIMINATION(HISTO_LOG):
    
    #construct and fill parent space
    N_parent = np.zeros(3, dtype=object)
    N_parent[0] = copy.copy(HISTO_LOG[len(HISTO_LOG)-1][0])
    N_parent[1] = np.zeros(n_lines) #Decision variable: frequencies
    N_parent[2] = np.zeros(n_KPIs) #place for storage kpi's
    
    #Make complete parent analysis
    global NAP_reduced
    global A_parent
    NAP_reduced = 'false'
    A_parent = copy.deepcopy(NETWORK_ANALYSIS_PROCEDURE(N_parent))
    #print A_parent[2][3,7][1]
    #print len(A_parent[1][0,7])
    NAP_reduced = 'true'
    
    #construct child spaces
    n_movements = int(np.sum(HISTO_LOG[len(HISTO_LOG)-1][0]))
    N_child = np.zeros((n_movements, 3), dtype=object)
    
    #fill child space as parents
    for m in range(len(N_child)):
        N_child[m][0] = copy.copy(HISTO_LOG[len(HISTO_LOG)-1][0]) #Decision variable: active lines
        N_child[m][1] = np.zeros(n_lines) #Decision variable: frequencies
        N_child[m][2] = np.zeros(n_KPIs) #place for storage kpi's

    #differentiate children to parents by suggesting elimination    
    k_count = 0
    for m in range(len(N_child)):
        for k in range(n_lines):
            if k == k_count:
                if N_child[m][0][k] == 0:
                    k_count = k_count + 1
                elif N_child[m][0][k] == 1:
                    N_child[m][0][k] = 0
                    k_count = k_count + 1
                    break
    
    #build list to compare neigbourhood objective function (Z) scores
    N_child_OV = list()
    
    #Perform NAP for all child-neighbourhoods
    for m in range(len(N_child)):
        N_child[m] = NETWORK_ANALYSIS_PROCEDURE(N_child[m])[0]
        N_child_OV.append(N_child[m][2][0])
    #print test_matrix[0]
    #locate best possible move
    Min_OV = np.min(N_child_OV)
    idxOV = np.where(N_child_OV == Min_OV)

    #translate index best move eighbourhood to specific line
    count_idx_line = -1 
    for k in range(len(POOL_OF_LINES)):
        if HISTO_LOG[len(HISTO_LOG)-1][0][k] == 1:
            count_idx_line = count_idx_line + 1  
            if count_idx_line == idxOV[0][0]:
                idx_k = k
    
    return Min_OV, idx_k, N_child[idxOV[0][0]]

#------------------------------------------------------------------------------

#OPERATION 8 (LINE ADDITION)
 
def OPERATION_8_LINE_ADDITION(HISTO_LOG):

    #construct and fill parent space
    N_parent = np.zeros(3, dtype=object)
    N_parent[0] = copy.copy(HISTO_LOG[len(HISTO_LOG)-1][0])
    N_parent[1] = np.zeros(n_lines) #Decision variable: frequencies
    N_parent[2] = np.zeros(n_KPIs) #place for storage kpi's
    
    #Make complete parent analysis
    global A_parent
    A_parent = copy.deepcopy(NETWORK_ANALYSIS_PROCEDURE(N_parent))
    #NAP_reduced = 'true'
    
    #construct child spaces
    n_movements = int(n_lines - np.sum(HISTO_LOG[len(HISTO_LOG)-1][0]))
    N_child = np.zeros((n_movements, 3), dtype=object)
    
    #fill child space as parents
    for m in range(len(N_child)):
        N_child[m][0] = copy.copy(HISTO_LOG[len(HISTO_LOG)-1][0]) #Decision variable: active lines
        N_child[m][1] = np.zeros(n_lines) #Decision variable: frequencies
        N_child[m][2] = np.zeros(n_KPIs) #place for storage kpi's
        
    
    #differentiate children to parents by suggesting addition
    k_count = 0
    for m in range(len(N_child)):
        for k in range(n_lines):
            if k == k_count:
                if N_child[m][0][k] == 1:
                    k_count = k_count + 1
                elif N_child[m][0][k] == 0:
                    N_child[m][0][k] = 1
                    k_count = k_count + 1
                    break
                
    #build list to compare neigbourhood objective function (Z) scores
    N_child_OV = list()            
    
    #Perform NAP for all child-neighbourhoods
    for m in range(len(N_child)):
        N_child[m] = NETWORK_ANALYSIS_PROCEDURE(N_child[m])[0]
        N_child_OV.append(N_child[m][2][0])
    #print test_matrix[0]
    
    #locate best possible move
    Min_OV = np.min(N_child_OV)
    idxOV = np.where(N_child_OV == Min_OV)    
    #translate index best move eighbourhood to specific line
    count_idx_line = -1 
    for k in range(len(POOL_OF_LINES)):
        if HISTO_LOG[len(HISTO_LOG)-1][0][k] == 0:
            count_idx_line = count_idx_line + 1
            if count_idx_line == idxOV[0][0]:
                idx_k = k
                
    return Min_OV, idx_k, N_child[idxOV[0][0]]
    
#------------------------------------------------------------------------------

#OPERATION 10a (LOCAL IMPROVEMENT)

def OPERATION_10_LOCAL_IMPROVEMENT(decision_path):
  
    #construct and fill parent space
    N_parent = np.zeros(3, dtype=object)
    N_parent[0] = copy.copy(decision_path[len(decision_path)-1][0])
    N_parent[1] = np.zeros(n_lines) #Decision variable: frequencies
    N_parent[2] = np.zeros(n_KPIs) #place for storage kpi's
    
    #Make complete parent analysis
    global A_parent
    A_parent = copy.deepcopy(NETWORK_ANALYSIS_PROCEDURE(N_parent))
    
    #construct child spaces
    n_movements = n_lines
    N_child = np.zeros((n_movements, 3), dtype=object)
    
    #fill child space as parents
    for m in range(len(N_child)):
        N_child[m][0] = copy.copy(decision_path[len(decision_path)-1][0]) #Decision variable: active lines
        N_child[m][1] = np.zeros(n_lines) #Decision variable: frequencies
        N_child[m][2] = np.zeros(n_KPIs) #place for storage kpi's
    
    #differentiate children to parents by suggesting either elimination or addition
    for m in range(len(N_child)):
        if N_child[m][0][m] == 0:
            N_child[m][0][m] = 1
        else:
            N_child[m][0][m] = 0
    
    #build list to compare neigbourhood objective function (Z) scores
    N_child_OV = list()
    
    #Perform NAP for all child-neighbourhoods
    for m in range(len(N_child)):
        N_child[m] = NETWORK_ANALYSIS_PROCEDURE(N_child[m])[0]
        N_child_OV.append(N_child[m][2][0])
        
    #make returning to identical impossible
    for m in range(len(N_child)):

        if (N_child[m][0]==HISTO_LOG[len(HISTO_LOG)-1][0]).all():
            #print 'identical',
          #  print N_child[m][2][0],
            N_child[m][2][0] = float('inf')
          #  print N_child[m][2][0]
        
    #find best moves and associated OV's
    best_steps = heapq.nsmallest(scope_width*6, N_child_OV)
    idxOV = ([np.where(N_child_OV == best_steps[0]),  np.where(N_child_OV == best_steps[1]),  np.where(N_child_OV == best_steps[2]),
              np.where(N_child_OV == best_steps[3]),  np.where(N_child_OV == best_steps[4]),  np.where(N_child_OV == best_steps[5]),
              np.where(N_child_OV == best_steps[6]),  np.where(N_child_OV == best_steps[7]),  np.where(N_child_OV == best_steps[8]),
              np.where(N_child_OV == best_steps[9]),  np.where(N_child_OV == best_steps[10]), np.where(N_child_OV == best_steps[11]),
              np.where(N_child_OV == best_steps[12]), np.where(N_child_OV == best_steps[13]), np.where(N_child_OV == best_steps[14]),
              np.where(N_child_OV == best_steps[15]), np.where(N_child_OV == best_steps[16]), np.where(N_child_OV == best_steps[17])])
    #print idxOV
    #print N_child[idxOV[0][0][0]]
    
    return (N_child[idxOV[0][0][0]],  N_child[idxOV[1][0][0]],  N_child[idxOV[2][0][0]],
            N_child[idxOV[3][0][0]],  N_child[idxOV[4][0][0]],  N_child[idxOV[5][0][0]],
            N_child[idxOV[6][0][0]],  N_child[idxOV[7][0][0]],  N_child[idxOV[8][0][0]],
            N_child[idxOV[9][0][0]],  N_child[idxOV[10][0][0]], N_child[idxOV[11][0][0]],
            N_child[idxOV[12][0][0]], N_child[idxOV[13][0][0]], N_child[idxOV[14][0][0]],
            N_child[idxOV[15][0][0]], N_child[idxOV[16][0][0]], N_child[idxOV[17][0][0]])
    
#------------------------------------------------------------------------------

#OPERATION 10b  (LOCAL IMPROVEMENT)

def OPERATION_10_TREE_STRUCTURE(HISTO_LOG,LVLa,LVLb,LVLc):
            
    scope_width = 3
    decision_paths = np.zeros(scope_width**2, dtype = object)
    
    initial_histo_log[1] = copy.deepcopy(HISTO_LOG[len(HISTO_LOG)-1])
    
    for R in range(len(decision_paths)):
        decision_paths[R] = initial_histo_log
    
    #determine first three tree options and assign to decision paths
    OPER_10_A = copy.deepcopy(OPERATION_10_LOCAL_IMPROVEMENT(decision_paths[0]))    
    for R in range(scope_width):
        decision_paths[R+0] = np.append(decision_paths[R+0], [OPER_10_A[LVLa]], axis=0)
        decision_paths[R+3] = np.append(decision_paths[R+3], [OPER_10_A[LVLb]], axis=0)
        decision_paths[R+6] = np.append(decision_paths[R+6], [OPER_10_A[LVLc]], axis=0)
    print percentage[0],   
    
    #determine results for second tree level 
    OPER_10_A_A = copy.deepcopy(OPERATION_10_LOCAL_IMPROVEMENT(decision_paths[0]))
    print percentage[1],
    OPER_10_A_B = copy.deepcopy(OPERATION_10_LOCAL_IMPROVEMENT(decision_paths[3]))
    print percentage[2], 
    OPER_10_A_C = copy.deepcopy(OPERATION_10_LOCAL_IMPROVEMENT(decision_paths[6]))
    print percentage[3],
    
    #assign results to second tree levels
    for R in range(scope_width):
        decision_paths[R+0] = np.append(decision_paths[R+0], [OPER_10_A_A[R+LVLa]], axis=0)
        decision_paths[R+3] = np.append(decision_paths[R+3], [OPER_10_A_B[R+LVLa]], axis=0)
        decision_paths[R+6] = np.append(decision_paths[R+6], [OPER_10_A_C[R+LVLa]], axis=0)
    
    #Mark results that moved back to the original position of the last histo_log
    identicallity = np.zeros(9)
    for R in range(9):
        if (decision_paths[R][len(decision_paths[R])-1][0]==HISTO_LOG[len(HISTO_LOG)-1][0]).all():
            identicallity[R] = 1
    
    #determine steepest descent from non-identical second tree levels
    for R in range(len(decision_paths)):
        rangeR = range(9-(9-R))
        unique = 'true'
        while unique == 'true':
            if identicallity[R] == 0:
                
                #when improvement compared last tree level, make descent and add to decision path
                OPER_10_A_A_X = copy.deepcopy(OPERATION_10_LOCAL_IMPROVEMENT(decision_paths[R]))
                if OPER_10_A_A_X[0][2][0] < decision_paths[R][len(decision_paths[R])-1][2][0]: #if improving
                    for r in rangeR:#if unique
                        if (decision_paths[r][len(decision_paths[r])-1][0]==decision_paths[R][len(decision_paths[R])-1][0]).all():
                            unique = 'false'
                    decision_paths[R] = np.append(decision_paths[R], [OPER_10_A_A_X[0]], axis=0)

                    #when improvement compared last tree level, make descent and add to decision path
                    OPER_10_A_A_Y = copy.deepcopy(OPERATION_10_LOCAL_IMPROVEMENT(decision_paths[R]))
                    if OPER_10_A_A_Y[0][2][0] < decision_paths[R][len(decision_paths[R])-1][2][0]: #if improving
                        for r in rangeR: #if unique
                            if (decision_paths[r][len(decision_paths[r])-1][0]==decision_paths[R][len(decision_paths[R])-1][0]).all():
                                unique = 'false'
                        decision_paths[R] = np.append(decision_paths[R], [OPER_10_A_A_Y[0]], axis=0)
                        
                        #when improvement compared last tree level, make descent and add to decision path
                        OPER_10_A_A_Z = copy.deepcopy(OPERATION_10_LOCAL_IMPROVEMENT(decision_paths[R]))
                        if OPER_10_A_A_Z[0][2][0] < decision_paths[R][len(decision_paths[R])-1][2][0]:
                            for r in rangeR: #if unique
                                if (decision_paths[r][len(decision_paths[r])-1][0]==decision_paths[R][len(decision_paths[R])-1][0]).all():
                                    unique = 'false'
                            decision_paths[R] = np.append(decision_paths[R], [OPER_10_A_A_Z[0]], axis=0)
                            
                            #when improvement compared last tree level, make descent and add to decision path
                            OPER_10_A_A_ZZ = copy.deepcopy(OPERATION_10_LOCAL_IMPROVEMENT(decision_paths[R]))
                            if OPER_10_A_A_ZZ[0][2][0] < decision_paths[R][len(decision_paths[R])-1][2][0]:
                                for r in rangeR: #if unique
                                    if (decision_paths[r][len(decision_paths[r])-1][0]==decision_paths[R][len(decision_paths[R])-1][0]).all():
                                        unique = 'false'
                                decision_paths[R] = np.append(decision_paths[R], [OPER_10_A_A_ZZ[0]], axis=0)
                        
        #end loop and print  progress    
            unique = 'false'
        print percentage[R+4],
        if R == 8:
            print ''
            
    
    #check for new identicallity values
    for R in range(9):
        if (decision_paths[R][len(decision_paths[R])-1][0]==HISTO_LOG[len(HISTO_LOG)-1][0]).all():
            identicallity[R] = 1
    
    #test if improvement can be found
    best_path_values = [[int(999),HISTO_LOG[len(HISTO_LOG)-1][2][0]]]
    for R in range(len(decision_paths)):
        if identicallity[R] == 0:
            if decision_paths[R][len(decision_paths[R])-1][2][0] < (best_path_values[0][1] + epsilon0):         
                best_path_values = np.append(best_path_values, [[int(R), decision_paths[R][len(decision_paths[R])-1][2][0]]], axis = 0) 
    
    return decision_paths, best_path_values
    
#------------------------------------------------------------------------------



"""----------------------------------------------------------------------------
-------------------------------  Operation 6  ---------------------------------
-----------------------------  Line elimination  ------------------------------
----------------------------------------------------------------------------"""

#------------------------------------------------------------------------------

time_begin_6 = time.time()

#------------------------------------------------------------------------------

#excecute primary analysis - find performance of empty line Configuration

#primary analysis can use reduced NAP
NAP_reduced = 'true'

#construction of empty neighbourbourhood space
N_empty = np.zeros((3), dtype=object)
N_empty[0] = np.zeros(n_lines) #all lines are acitve
N_empty[1] = np.zeros(n_lines)
N_empty[2] = np.zeros(n_KPIs) 

#make dummy parent analysis which is infeasible for all OD-pairs
A_parent = np.zeros(3, dtype=object)
A_parent[2] = np.zeros((length_V, length_V,3))

#set reference values to be zero
C_use_prim = 0 
C_ope_prim = 0 
C_ext_prim = 0 

#perform NAP on empty neighbourhood space
NAP_empty = 'true'
A_empty = NETWORK_ANALYSIS_PROCEDURE(N_empty)[0]
NAP_empty = 'false'

#store boundary values
C_bound_empty = (C_use_prim, C_ope_prim, C_ext_prim) 

#------------------------------------------------------------------------------

#excecute secondary analysis - find performance of fully activated line Configuration

#secondary analysis cannot use reduced NAP
NAP_reduced = 'false'

#construction of primary full neighbourbourhood space
N_primary = np.zeros((3), dtype=object)
N_primary[0] = np.ones(n_lines) #all lines are acitve
N_primary[1] = np.zeros(n_lines)
N_primary[2] = np.zeros(n_KPIs) 

#make dummy parent analysis which is feasible for all OD-pairs
A_parent = np.ones(3, dtype=object)
A_parent[2] = np.ones((length_V, length_V,3))

#set improvement to be true as a starting point for evaluation
improvement6 = 'true'

#perform NAP on primary neighbourhood space
        #A_primary = NETWORK_ANALYSIS_PROCEDURE(N_primary)[0]
A_primary = N_primary

#store this result in the HISTO_LOG
HISTO_LOG = np.append([HISTO_LOG], [A_primary], axis=0)
initial_histo_log = copy.deepcopy(HISTO_LOG)
HISTO_LOG = np.append(HISTO_LOG, [A_empty], axis=0)

#------------------------------------------------------------------------------

#Tertiay analysis - find ideal reduction moves

#set itecration counter
iteration_counter = 0
improvement6 = 'true';  improvement8 = 'true';  improvement10 = 'true'

while improvement6 == 'true' or improvement8 == 'true' or improvement10 == 'true':
    
    #check for maximu running time
    if  (time.time() - start_time) > 518400:
        print 'Algorithm terminated, maximum calculation time surpassed'
        improvement6 == 'false' ; improvement8 == 'false' or improvement10 == 'false'
        break
        
    while improvement6 == 'true' or improvement8 == 'true':
        
        #execute tertiary analysis
        while improvement8 == 'true':
            
            #save current HISTO_LOG 
            df = pd.DataFrame(HISTO_LOG).T
            doc_name     =    "/HISTO_LOG.xlsx"
            df.to_excel(excel_writer = saving_path_string+""+doc_name)
            
            #save current time
            current_time = time.time()
            modeltimer = np.append(modeltimer, ([[datetime.datetime.fromtimestamp(start_time).strftime('%Y-%m-%d %H:%M:%S'),datetime.datetime.fromtimestamp(current_time).strftime('%Y-%m-%d %H:%M:%S'), current_time - start_time]]), axis=0)
            df = pd.DataFrame(modeltimer).T
            doc_name     =    "/MODEL_TIMER.xlsx"
            df.to_excel(excel_writer = saving_path_string+""+doc_name)
                        
            #start iteration timer and counter
            iteration_timer = time.time()
            iteration_counter = iteration_counter + 1
            
            #Perform tertiary analysis
            OPER_8 = OPERATION_8_LINE_ADDITION(HISTO_LOG)
        
            #add solution to HISTO LOG when it brings improvement 
            if OPER_8[0] < HISTO_LOG[len(HISTO_LOG)-1][2][0]:
                HISTO_LOG = np.append(HISTO_LOG, [OPER_8[2]], axis=0)
                
                #declare elimination of specific line
                print (Fore.GREEN),(Style.BRIGHT)
                print 'ITERATION:', iteration_counter, '(IMPROVEMENT)' ,(Style.RESET_ALL)
                print 'Add line: ', OPER_8[1], POOL_OF_LINES[OPER_8[1],2]
                print 'new objective value:', round(OPER_8[0],0)
                print 'last iteration took:', round(time.time() - iteration_timer, 2), 'seconds'
                print 'estimated remaining time:', ((n_lines_cons - iteration_counter) * (time.time() - iteration_timer))/3
                improvement6 = 'true' ; improvement8 = 'true'
                            
            #end script when no further improvement is found
            else:
                print (Fore.YELLOW), (Style.BRIGHT)
                print 'ITERATION:', iteration_counter, '(DETERIORATION)' ,(Style.RESET_ALL)
                print 'potential addition line:', OPER_8[1], POOL_OF_LINES[OPER_8[1],2]
                print 'potential objective value:', round(OPER_8[0],0)
                print ''
                print '', (Fore.YELLOW), (Style.BRIGHT + 'initiate local skipping procedure:'), (Style.RESET_ALL)
                
                #add deteriorating step to alternative HISTO_LOG
                HISTO_LOG_ALT = np.append(HISTO_LOG, [OPER_8[2]], axis=0)
            
                #execute forecasting step
                skip_max_oper8 = 10
                skip_count = 1
                while skip_count <= skip_max_oper8: #binnen de max hoeveelheid skips
                    
                    if np.sum(HISTO_LOG_ALT[len(HISTO_LOG_ALT)-1][0]) != n_lines: #zolang de laatste lijn nog niet geelimineerd is
                        #perform forecasting calulation
                        print '', '','skip', skip_count,':', 
                        OPER_8_ALT = OPERATION_8_LINE_ADDITION(HISTO_LOG_ALT)
                        HISTO_LOG_ALT = np.append(HISTO_LOG_ALT, [OPER_8_ALT[2]], axis=0)
                        skip_count = skip_count + 1
                        iteration_counter = iteration_counter + 1
                        print 'add line:', OPER_8_ALT[1],'-','( OV:', round(OPER_8_ALT[0]), ')'
                        
                        if OPER_8_ALT[0] < HISTO_LOG[len(HISTO_LOG)-1][2][0]: #als de skipping value beter is
                            print '',(Fore.YELLOW), (Style.BRIGHT + 'improvement by skipping identified, skips are accepted'), (Style.RESET_ALL)
                            print ''
                            print (Fore.GREEN),(Style.BRIGHT),'ITERATION:', iteration_counter - skip_count + 1, '(SKIP PROCEDURE)' ,(Style.RESET_ALL)
                            print '','', 'add line: ', OPER_8[1], POOL_OF_LINES[OPER_8[1],2]
                            print '','', 'new objective value:', round(OPER_8[0],0)
                            print ''
                            
                            #print iterations made for skipping
                            for s in range(skip_count - 1):
                                print (Fore.GREEN),(Style.BRIGHT),'ITERATION:', iteration_counter - skip_count + 2 + s, '(SKIP PROCEDURE)' ,(Style.RESET_ALL)
                                print '','', 'add line: '
                                print '','', 'new objective value:', round(HISTO_LOG_ALT[len(HISTO_LOG_ALT)-1][2][0])
                                print ''
        
                            #save new HISTO_LOG
                            HISTO_LOG = HISTO_LOG_ALT
                            skip_count = float('inf')
                            improvement6 = 'true' ; improvement8 = 'true'
                        
                        else:
                            print '',(Fore.YELLOW), (Style.BRIGHT + 'trying more skips'), (Style.RESET_ALL)
                            iteration_counter = iteration_counter - skip_count + 1
                            n_lines_8end = sum(HISTO_LOG[len(HISTO_LOG)-1][0])
                            improvement8 = 'false'
                            
                    else:
                        print '',(Fore.YELLOW), (Style.BRIGHT + 'no further skipping improvement identified, skips are declined'), (Style.RESET_ALL)
                        print ''
                        print '-- -- -- -- -- -- -- -- -- -- -- --'
                        print (Fore.CYAN), (Style.BRIGHT + 'End of operation 8: full addition was explored, no further improvemend was found'), (Style.RESET_ALL)
                        print '-- -- -- -- -- -- -- -- -- -- -- --'
                        iteration_counter = iteration_counter - skip_count + 1
                        n_lines_8end = sum(HISTO_LOG[len(HISTO_LOG)-1][0])
                        skip_count = float('inf')
                        improvement8 = 'false'
                
                if OPER_8_ALT[0] > HISTO_LOG[len(HISTO_LOG)-1][2][0] and np.sum(HISTO_LOG_ALT[len(HISTO_LOG_ALT)-1][0]) != n_lines: #als de skipping value slechter is 
                    iteration_counter = iteration_counter - skip_count + 1
                    print '',(Fore.YELLOW), (Style.BRIGHT + 'no further skipping improvement identified, skips are declined'), (Style.RESET_ALL)
                    print ''
                    print '-- -- -- -- -- -- -- -- -- -- -- --'    
                    print(Fore.CYAN), (Style.BRIGHT + 'End of operation 8: no further improvement was found'), (Style.RESET_ALL)
                    print '-- -- -- -- -- -- -- -- -- -- -- --'
                    improvement8 = 'false'
                    skip_count = float('inf')
                    n_lines_8end = sum(HISTO_LOG[len(HISTO_LOG)-1][0])
                
            
        
        iteration_end8 = copy.copy(iteration_counter-1)
        
    
    #------------------------------------------------------------------------------
        
        """----------------------------------------------------------------------------
        -------------------------------  Operation 7  ---------------------------------
        --------------------------  Constraint Imposement  ----------------------------
        ----------------------------------------------------------------------------"""
        
        #------------------------------------------------------------------------------
        
        time_begin_7 = time.time()
        
        #------------------------------------------------------------------------------
        
        """----------------------------------------------------------------------------
        -------------------------------  Operation 8  ---------------------------------
        ------------------------------  Line addition  --------------------------------
        ----------------------------------------------------------------------------"""
        
        #------------------------------------------------------------------------------
        
        time_begin_8 = time.time()
        
        #------------------------------------------------------------------------------
        #global NAP_reduced
        NAP_reduced = 'false'
        
        
        
        
        #------------------------------------------------------------------------------
        
        #execute tertiary analysis
        while improvement6 == 'true':
            
            #save current HISTO_LOG 
            df = pd.DataFrame(HISTO_LOG).T
            doc_name     =    "/HISTO_LOG.xlsx"
            df.to_excel(excel_writer = saving_path_string+""+doc_name)
                        
            #save current time
            current_time = time.time()
            modeltimer = np.append(modeltimer, ([[datetime.datetime.fromtimestamp(start_time).strftime('%Y-%m-%d %H:%M:%S'),datetime.datetime.fromtimestamp(current_time).strftime('%Y-%m-%d %H:%M:%S'), current_time - start_time]]), axis=0)
            df = pd.DataFrame(modeltimer).T
            doc_name     =    "/MODEL_TIMER.xlsx"
            df.to_excel(excel_writer = saving_path_string+""+doc_name)
            
            #start iteration timer and counter
            iteration_timer = time.time()
            iteration_counter = iteration_counter + 1
            
            #Perform tertiary analysis
            OPER_6 = OPERATION_6_LINE_ELIMINATION(HISTO_LOG)
            
            #add solution to HISTO LOG when it brings improvement 
            if OPER_6[0] < HISTO_LOG[len(HISTO_LOG)-1][2][0]:
                HISTO_LOG = np.append(HISTO_LOG, [OPER_6[2]], axis=0)
                
                #declare elimination of specific line
                print (Fore.GREEN),(Style.BRIGHT)
                print 'ITERATION:', iteration_counter, '(IMPROVEMENT)' ,(Style.RESET_ALL)
                print 'eliminate line: ', OPER_6[1], POOL_OF_LINES[OPER_6[1],2]
                print 'new objective value:', round(OPER_6[0],0)
                print 'last iteration took:', round(time.time() - iteration_timer, 2), 'seconds'
                print 'estimated remaining time:', ((n_lines_cons - iteration_counter) * (time.time() - iteration_timer))/3
                improvement6 = 'true'; improvement8 = 'true'
                
                #break operation when last line has been eliminated
                if np.sum(HISTO_LOG[len(HISTO_LOG)-1][0]) == 0:
                    n_lines_6end = 0
                    print '-- -- -- -- -- -- -- -- -- -- -- --'
                    print (Fore.CYAN), (Style.BRIGHT + 'End of operation 6: All lines have been eliminated'), (Style.RESET_ALL)
                    print '-- -- -- -- -- -- -- -- -- -- -- --'
                    print ''
                    improvement6 = 'false'
            
            #if no improvement is found
            else:
                    print (Fore.YELLOW), (Style.BRIGHT)
                    print 'ITERATION:', iteration_counter, '(DETERIORATION)' ,(Style.RESET_ALL)
                    print 'potential elimination line:', OPER_6[1], POOL_OF_LINES[OPER_6[1],2]
                    print 'potential objective value:', round(OPER_6[0],0)
                    print ''
                    print '', (Fore.YELLOW), (Style.BRIGHT + 'start local skipping procedure:'), (Style.RESET_ALL)
                    
                    #add deteriorating step to alternative HISTO_LOG
                    HISTO_LOG_ALT = np.append(HISTO_LOG, [OPER_6[2]], axis=0)
                    
                    #if no further lines can be eliminated
                    if np.sum(HISTO_LOG_ALT[len(HISTO_LOG_ALT)-1][0]) == 0:
                        print '',(Fore.YELLOW), (Style.BRIGHT + 'no further skipping possible, line set is fully deactivated'), (Style.RESET_ALL)
                        print ''
                        print '-- -- -- -- -- -- -- -- -- -- -- --'
                        print (Fore.CYAN), (Style.BRIGHT + 'End of operation 6: full elimination was explored, no further improvemend was found'), (Style.RESET_ALL)
                        print '-- -- -- -- -- -- -- -- -- -- -- --'
                        iteration_counter = iteration_counter - 1
                        improvement6 = 'false'
                        break
                
                    #execute forecasting step
                    skip_max_oper6 = 10
                    skip_count = 1
                    while skip_count <= skip_max_oper6: #binnen de max hoeveelheid skips
                        print '', '','skip', skip_count,':', 
                        if np.sum(HISTO_LOG_ALT[len(HISTO_LOG_ALT)-1][0]) != 0: #zolang de laatste lijn nog niet geelimineerd is
                            
                            #perform forecasting calulation
                            OPER_6_ALT = OPERATION_6_LINE_ELIMINATION(HISTO_LOG_ALT)
                            HISTO_LOG_ALT = np.append(HISTO_LOG_ALT, [OPER_6_ALT[2]], axis=0)
                            skip_count = skip_count + 1
                            iteration_counter = iteration_counter + 1
                            print 'eliminate line:', OPER_6_ALT[1],'-','( OV:', round(OPER_6_ALT[0]), ')'
                            
                            if OPER_6_ALT[0] < HISTO_LOG[len(HISTO_LOG)-1][2][0]: #als de skipping value beter is
                                print '',(Fore.YELLOW), (Style.BRIGHT + 'improvement by skipping identified, skips are accepted'), (Style.RESET_ALL)
                                print ''
                                print (Fore.GREEN),(Style.BRIGHT),'ITERATION:', iteration_counter - skip_count + 1, '(SKIP PROCEDURE)' ,(Style.RESET_ALL)
                                print '','', 'eliminate line: ', OPER_6[1], POOL_OF_LINES[OPER_6[1],2]
                                print '','', 'new objective value:', round(OPER_6[0],0)
                                print ''
                                
                                #print iterations made for skipping
                                for s in range(skip_count - 1):
                                    print (Fore.GREEN),(Style.BRIGHT),'ITERATION:', iteration_counter - skip_count + 2 + s, '(SKIP PROCEDURE)' ,(Style.RESET_ALL)
                                    print '','', 'eliminate line: '
                                    print '','', 'new objective value:', round(HISTO_LOG_ALT[len(HISTO_LOG_ALT)-1][2][0])
                                    print ''
        
                                #save new HISTO_LOG
                                HISTO_LOG = HISTO_LOG_ALT
                                skip_count = float('inf')
                                improvement6 = 'true' ; improvement8 = 'true'
                            
                            if np.sum(HISTO_LOG_ALT[len(HISTO_LOG_ALT)-1][0]) == 0:
                                print '',(Fore.YELLOW), (Style.BRIGHT + 'no further skipping improvement identified, skips are declined'), (Style.RESET_ALL)
                                print ''
                                print '-- -- -- -- -- -- -- -- -- -- -- --'
                                print (Fore.CYAN), (Style.BRIGHT + 'End of operation 6: full elimination was explored, no further improvemend was found'), (Style.RESET_ALL)
                                print '-- -- -- -- -- -- -- -- -- -- -- --'
                                iteration_counter = iteration_counter - skip_count
                                n_lines_6end = sum(HISTO_LOG[len(HISTO_LOG)-1][0])
                                skip_count = float('inf')
                                improvement6 = 'false'
                    
                    
                    if OPER_6_ALT[0] > HISTO_LOG[len(HISTO_LOG)-1][2][0] and np.sum(HISTO_LOG_ALT[len(HISTO_LOG_ALT)-1][0]) != 0: #als de skipping value slechter is 
                        iteration_counter = iteration_counter-1
                        print '',(Fore.YELLOW), (Style.BRIGHT + 'no further skipping improvement identified, skips are declined'), (Style.RESET_ALL)
                        print ''
                        print '-- -- -- -- -- -- -- -- -- -- -- --'    
                        print(Fore.CYAN), (Style.BRIGHT + 'End of operation 6: no further improvement was found'), (Style.RESET_ALL)
                        print '-- -- -- -- -- -- -- -- -- -- -- --'
                        iteration_counter = iteration_counter - skip_count + 1
                        improvement6 = 'false'
                        skip_count = float('inf')
                        n_lines_6end = sum(HISTO_LOG[len(HISTO_LOG)-1][0])
                        
        #------------------------------------------------------------------------------
        
        iteration_end6 = copy.copy(iteration_counter)
        
        #------------------------------------------------------------------------------
        
    
    """----------------------------------------------------------------------------
    -------------------------------  Operation 9  ---------------------------------
    ------------------------------  Line addition  --------------------------------
    ----------------------------------------------------------------------------"""
    
    #------------------------------------------------------------------------------
    
    time_begin_9 = time.time()
    
    #------------------------------------------------------------------------------
    
    #------------------------------------------------------------------------------
    
    """----------------------------------------------------------------------------
    ------------------------------  Operation 10  ---------------------------------
    ----------------------------  Local improvement  ------------------------------
    ----------------------------------------------------------------------------"""
    
    #------------------------------------------------------------------------------
    
    time_begin_10 = time.time()
    
    #------------------------------------------------------------------------------
    
    scope_width = 3
    decision_paths = np.zeros(scope_width**2, dtype = object)
    
    initial_histo_log[1] = copy.deepcopy(HISTO_LOG[len(HISTO_LOG)-1])
    
    for R in range(len(decision_paths)):
        decision_paths[R] = initial_histo_log
    
    #print decision_paths[0]
    
    
    NAP_reduced = 'false'
    
    
    #-----------------------------------------------------------------------------
        
    improvement10 = 'true'
    percentage = ['| 8%|','15%|','23%|','31%|','39%|','47%|','54%|','62%|','70%|','77%|','85%|','93%|','100%|']
    tree_structure= ['1-1','1-2','1-3','2-1','2-2','2-3','3-1','3-2','3-3',]
    counter_local_analysis = 1
    
    
    
    while improvement10 == 'true':
        
        #save current HISTO_LOG 
        df = pd.DataFrame(HISTO_LOG).T
        doc_name     =    "/HISTO_LOG.xlsx"
        df.to_excel(excel_writer = saving_path_string+""+doc_name)
                    
        #save current time
        current_time = time.time()
        modeltimer = np.append(modeltimer, ([[datetime.datetime.fromtimestamp(start_time).strftime('%Y-%m-%d %H:%M:%S'),datetime.datetime.fromtimestamp(current_time).strftime('%Y-%m-%d %H:%M:%S'), current_time - start_time]]), axis=0)
        df = pd.DataFrame(modeltimer).T
        doc_name     =    "/MODEL_TIMER.xlsx"
        df.to_excel(excel_writer = saving_path_string+""+doc_name)
        
        print (Fore.YELLOW), (Style.BRIGHT)
        print 'LOCAL ANALYSIS:', counter_local_analysis ,(Style.RESET_ALL)
        counter_local_analysis = counter_local_analysis + 1
        print 'Analyzing three level decision tree (1-2-3)'
        print 'loading...',
        
        #perform analysis for 1-2-3 tree
        TREE_ANALYSIS_123 = OPERATION_10_TREE_STRUCTURE(HISTO_LOG,0,1,2)
    
        #if improvement was found
        if len(TREE_ANALYSIS_123[1]) > 1:
    
            #locate best decision_path
            for P in range(len(TREE_ANALYSIS_123[1])):
                if TREE_ANALYSIS_123[1][P][1] == np.min(TREE_ANALYSIS_123[1][:,1]):
                    path_decided = copy.copy(TREE_ANALYSIS_123[0][int(TREE_ANALYSIS_123[1][P][0])])
                    break
            print 'improvement was found using decision tree:', tree_structure[int(TREE_ANALYSIS_123[1][P][0])]
            print '' 
            #append steps of best decision path to HISTO_LOG
            for S in range(len(path_decided)-2):
                HISTO_LOG = np.append(HISTO_LOG, [path_decided[S+2]], axis=0)
                print (Fore.GREEN),(Style.BRIGHT),'ITERATION:', iteration_counter, '(IMPROVEMENT)' ,(Style.RESET_ALL)
                print '','', 'add/eliminate line: xxx'
                print '','', 'new objective value:', round(HISTO_LOG[len(HISTO_LOG)-1][2][0])
                print ''
                iteration_counter = iteration_counter + 1
            improvement6 = 'true' ; improvement8 = 'true'; improvement10 = 'false'
            
        #if no improvement was found        
        else:
            print 'no improvement was found....'
            print '' 
            #start 4-6 tree search
            print 'Analyzing three level decision tree (4-5-6)'
            print 'loading...',
        
            #perform analysis for 1-2-3 tree
            TREE_ANALYSIS_456 = OPERATION_10_TREE_STRUCTURE(HISTO_LOG,3,4,5)
            
            #if improvement was found
            if len(TREE_ANALYSIS_456[1]) > 1:
    
                #locate best decision_path
                for P in range(len(TREE_ANALYSIS_456[1])):
                    if TREE_ANALYSIS_456[1][P][1] == np.min(TREE_ANALYSIS_456[1][:,1]):
                        path_decided = copy.copy(TREE_ANALYSIS_456[0][int(TREE_ANALYSIS_456[1][P][0])])
                        break
                print 'improvement was found using decision tree:', tree_structure[int(TREE_ANALYSIS_456[1][P][0])]
                print '' 
                #append steps of best decision path to HISTO_LOG
                for S in range(len(path_decided)-2):
                    HISTO_LOG = np.append(HISTO_LOG, [path_decided[S+2]], axis=0)
                    print (Fore.GREEN),(Style.BRIGHT),'ITERATION:', iteration_counter, '(IMPROVEMENT)' ,(Style.RESET_ALL)
                    print '','', 'add/eliminate line: xxx'
                    print '','', 'new objective value:', round(HISTO_LOG[len(HISTO_LOG)-1][2][0])
                    print ''
                    iteration_counter = iteration_counter + 1
                improvement6 = 'true' ; improvement8 = 'true'; improvement10 = 'false'
                
            else:
                print 'no improvement was found....'
                print '' 
                #start 7-9 tree search
                print 'Analyzing three level decision tree (7-8-9)'
                print 'loading...',
            
                #perform analysis for 1-2-3 tree
                TREE_ANALYSIS_789 = OPERATION_10_TREE_STRUCTURE(HISTO_LOG,6,7,8)
                
                #if improvement was found
                if len(TREE_ANALYSIS_789[1]) > 1:
        
                    #locate best decision_path
                    for P in range(len(TREE_ANALYSIS_789[1])):
                        if TREE_ANALYSIS_789[1][P][1] == np.min(TREE_ANALYSIS_789[1][:,1]):
                            path_decided = copy.copy(TREE_ANALYSIS_789[0][int(TREE_ANALYSIS_789[1][P][0])])
                            break
                    print 'improvement was found using decision tree:', tree_structure[int(TREE_ANALYSIS_789[1][P][0])]
                    print '' 
                    #append steps of best decision path to HISTO_LOG
                    for S in range(len(path_decided)-2):
                        HISTO_LOG = np.append(HISTO_LOG, [path_decided[S+2]], axis=0)
                        print (Fore.GREEN),(Style.BRIGHT),'ITERATION:', iteration_counter, '(IMPROVEMENT)' ,(Style.RESET_ALL)
                        print '','', 'add/eliminate line: xxx'
                        print '','', 'new objective value:', round(HISTO_LOG[len(HISTO_LOG)-1][2][0])
                        print ''
                        iteration_counter = iteration_counter + 1
                    improvement6 = 'true' ; improvement8 = 'true'; improvement10 = 'false'
                    
                else:                    
                    print 'no improvement was found....'
                    print '' 
                    #start 10-12 tree search
                    print 'Analyzing three level decision tree (10-11-12)'
                    print 'loading...',
                
                    #perform analysis for 1-2-3 tree
                    TREE_ANALYSIS_101112 = OPERATION_10_TREE_STRUCTURE(HISTO_LOG,9,10,11)
                    
                    #if improvement was found
                    if len(TREE_ANALYSIS_101112[1]) > 1:
            
                        #locate best decision_path
                        for P in range(len(TREE_ANALYSIS_101112[1])):
                            if TREE_ANALYSIS_101112[1][P][1] == np.min(TREE_ANALYSIS_101112[1][:,1]):
                                path_decided = copy.copy(TREE_ANALYSIS_101112[0][int(TREE_ANALYSIS_101112[1][P][0])])
                                break
                        print 'improvement was found using decision tree:', tree_structure[int(TREE_ANALYSIS_101112[1][P][0])]
                        print '' 
                        #append steps of best decision path to HISTO_LOG
                        for S in range(len(path_decided)-2):
                            HISTO_LOG = np.append(HISTO_LOG, [path_decided[S+2]], axis=0)
                            print (Fore.GREEN),(Style.BRIGHT),'ITERATION:', iteration_counter, '(IMPROVEMENT)' ,(Style.RESET_ALL)
                            print '','', 'add/eliminate line: xxx'
                            print '','', 'new objective value:', round(HISTO_LOG[len(HISTO_LOG)-1][2][0])
                            print ''
                            iteration_counter = iteration_counter + 1
                        improvement6 = 'true' ; improvement8 = 'true'; improvement10 = 'false'
                        
                    else:
                        print 'no improvement was found....'
                        print '' 
                        #start 13-15 tree search
                        print 'Analyzing three level decision tree (13-14-15)'
                        print 'loading...',
                    
                        #perform analysis for 1-2-3 tree
                        TREE_ANALYSIS_131415 = OPERATION_10_TREE_STRUCTURE(HISTO_LOG,12,13,14)
                        
                        #if improvement was found
                        if len(TREE_ANALYSIS_131415[1]) > 1:
                
                            #locate best decision_path
                            for P in range(len(TREE_ANALYSIS_131415[1])):
                                if TREE_ANALYSIS_131415[1][P][1] == np.min(TREE_ANALYSIS_131415[1][:,1]):
                                    path_decided = copy.copy(TREE_ANALYSIS_131415[0][int(TREE_ANALYSIS_131415[1][P][0])])
                                    break
                            print 'improvement was found using decision tree:', tree_structure[int(TREE_ANALYSIS_131415[1][P][0])]
                            print '' 
                            #append steps of best decision path to HISTO_LOG
                            for S in range(len(path_decided)-2):
                                HISTO_LOG = np.append(HISTO_LOG, [path_decided[S+2]], axis=0)
                                print (Fore.GREEN),(Style.BRIGHT),'ITERATION:', iteration_counter, '(IMPROVEMENT)' ,(Style.RESET_ALL)
                                print '','', 'add/eliminate line: xxx'
                                print '','', 'new objective value:', round(HISTO_LOG[len(HISTO_LOG)-1][2][0])
                                print ''
                                iteration_counter = iteration_counter + 1
                            improvement6 = 'true' ; improvement8 = 'true'; improvement10 = 'false'   
                            
                        else:
                            print 'no improvement was found....'
                            print '' 
                            #start 16-18 tree search
                            print 'Analyzing three level decision tree (16-17-18)'
                            print 'loading...',
                        
                            #perform analysis for 1-2-3 tree
                            TREE_ANALYSIS_161718 = OPERATION_10_TREE_STRUCTURE(HISTO_LOG,15,16,17)
                            
                            #if improvement was found
                            if len(TREE_ANALYSIS_161718[1]) > 1:
                    
                                #locate best decision_path
                                for P in range(len(TREE_ANALYSIS_161718[1])):
                                    if TREE_ANALYSIS_161718[1][P][1] == np.min(TREE_ANALYSIS_161718[1][:,1]):
                                        path_decided = copy.copy(TREE_ANALYSIS_161718[0][int(TREE_ANALYSIS_161718[1][P][0])])
                                        break
                                print 'improvement was found using decision tree:', tree_structure[int(TREE_ANALYSIS_161718[1][P][0])]
                                print '' 
                                #append steps of best decision path to HISTO_LOG
                                for S in range(len(path_decided)-2):
                                    HISTO_LOG = np.append(HISTO_LOG, [path_decided[S+2]], axis=0)
                                    print (Fore.GREEN),(Style.BRIGHT),'ITERATION:', iteration_counter, '(IMPROVEMENT)' ,(Style.RESET_ALL)
                                    print '','', 'add/eliminate line: xxx'
                                    print '','', 'new objective value:', round(HISTO_LOG[len(HISTO_LOG)-1][2][0])
                                    print ''
                                    iteration_counter = iteration_counter + 1
                                improvement6 = 'true' ; improvement8 = 'true'; improvement10 = 'false' 
                    
                            else:                
                                print (Fore.YELLOW), (Style.BRIGHT)
                                print 'no further improvement identified, local analysis results are declined', (Style.RESET_ALL)
                                print ''
                                print '-- -- -- -- -- -- -- -- -- -- -- --'    
                                print(Fore.CYAN), (Style.BRIGHT + 'End of operation 10: no further improvement was found'), (Style.RESET_ALL)
                                print '-- -- -- -- -- -- -- -- -- -- -- --'
                                improvement10 = 'false'
                            
    



"""----------------------------------------------------------------------------
--------------------------------  POSTSCRIPT  ---------------------------------
-----------------------------  Output Generation  -----------------------------
----------------------------------------------------------------------------"""

#------------------------------------------------------------------------------

#save final Histo_log
df = pd.DataFrame(HISTO_LOG).T
df.to_excel(excel_writer = "H:/#Afstuderen/Heuristic_Model/#HM_bronbestand/HISTO_LOG.xlsx")

#delete first two HISTO_LOG entries (zeros solution and full solution)
HISTO_LOG_COMPLETE = copy.deepcopy(HISTO_LOG)
HISTO_LOG = np.delete(HISTO_LOG, [0], axis=0) #empty iteration
HISTO_LOG = np.delete(HISTO_LOG, [0], axis=0) #full iteration

#------------------------------------------------------------------------------

#define figure size
plt.rcParams["figure.figsize"] = (7,4)

#------------------------------------------------------------------------------

#development cost development plot (stacked)

dev_C_user = ([]); dev_C_oper = ([]); dev_C_ext = ([])
for h in range(len(HISTO_LOG)):
    dev_C_user.append(HISTO_LOG[h][2][1])
    dev_C_oper.append(HISTO_LOG[h][2][2])
    dev_C_ext.append(HISTO_LOG[h][2][3])

dev_C_tot = np.zeros(len(HISTO_LOG))
dev_C_range = np.zeros(len(HISTO_LOG))
for h in range(len(HISTO_LOG)):
    dev_C_tot[h] = dev_C_user[h] + dev_C_oper[h] + dev_C_ext[h]
    dev_C_range[h] = abs(dev_C_user[h]) + abs(dev_C_oper[h]) + abs(dev_C_ext[h])
x=range(0,len(HISTO_LOG))
y1=dev_C_oper; y2=dev_C_user; y3=dev_C_ext

#plot lines and ticks
plt.axhline(y=0, xmin=0.05, xmax=0.95, color=cl_black[0])
plt.stackplot(x,dev_C_tot,colors=[cl_purple_bright[3]])
plt.plot(x,  dev_C_tot,  label='Total System Costs',       color = cl_purple_bright[0],   linewidth = 2)
plt.plot(x,  y1,         label='Total Operators Costs',    color = cl_blue_dark[0],       linewidth = 2)
plt.plot(x,  y3,         label='Total External Costs',     color = cl_green_light[1],     linewidth = 2)
plt.plot(x,  y2,         label='Total User Costs',         color = cl_red[2],             linewidth = 2)


#plt.axvline(x=iteration_end6, color = 'k')
#plt.axvline(x=iteration_end8, color = 'k')

#define grpah characteristics
plt.title('Cost development')
plt.legend(bbox_to_anchor=(1., 1.0))
plt.xlabel('Iteration [-]')
plt.ylabel('Costs [Euro]')
plt.show()



#------------------------------------------------------------------------------

dev_c_access_ptv = ([]); dev_c_waiting_ptv = ([]); dev_c_invehicle_ptv = ([]); dev_c_transfer_ptv = ([]); dev_c_egress_ptv = ([])
dev_c_access_ngt = ([]); dev_c_waiting_ngt = ([]); dev_c_invehicle_ngt = ([]); dev_c_transfer_ngt = ([]); dev_c_egress_ngt = ([])

dev_c_RSo = ([]); dev_c_RSm = ([]) 

dev_c_ext = ([])


for h in range(len(HISTO_LOG)):
    #dev_c_ext.append(HISTO_LOG[h][2][3])
    #print dev_C_range[h]
    if HISTO_LOG[h][2][4] - c_acc_prim > 0:
        dev_c_access_ptv.append((HISTO_LOG[h][2][4] - c_acc_prim + HISTO_LOG[h][2][8] - c_egr_prim)) ; dev_c_access_ngt.append(0.0)
    else:
        dev_c_access_ngt.append((HISTO_LOG[h][2][4] - c_acc_prim + HISTO_LOG[h][2][8] - c_egr_prim)) ; dev_c_access_ptv.append(0.0)
        
    if HISTO_LOG[h][2][5] - c_wai_prim > 0:
        dev_c_waiting_ptv.append((HISTO_LOG[h][2][5] - c_wai_prim)) ; dev_c_waiting_ngt.append(0.0)
    else:
        dev_c_waiting_ngt.append((HISTO_LOG[h][2][5] - c_wai_prim)) ; dev_c_waiting_ptv.append(0.0)
        
    if HISTO_LOG[h][2][6] - c_inv_prim > 0:
        dev_c_invehicle_ptv.append((HISTO_LOG[h][2][6] - c_inv_prim)) ; dev_c_invehicle_ngt.append(0.0)
    else:
        dev_c_invehicle_ngt.append((HISTO_LOG[h][2][6] - c_inv_prim)) ; dev_c_invehicle_ptv.append(0.0)
        
    if HISTO_LOG[h][2][7] - c_trf_prim > 0:
        dev_c_transfer_ptv.append((HISTO_LOG[h][2][7] - c_trf_prim)) ; dev_c_transfer_ngt.append(0.0)
    else:
        dev_c_transfer_ngt.append((HISTO_LOG[h][2][7] - c_trf_prim)) ; dev_c_transfer_ptv.append(0.0)
        
    if HISTO_LOG[h][2][8] - c_egr_prim > 0:
        dev_c_egress_ptv.append((HISTO_LOG[h][2][8] - c_egr_prim)) ; dev_c_egress_ngt.append(0.0)
    else:
        dev_c_egress_ngt.append((HISTO_LOG[h][2][8] - c_egr_prim)) ; dev_c_egress_ptv.append(0.0)
           
    dev_c_RSo.append((HISTO_LOG[h][2][9]))
    dev_c_RSm.append((HISTO_LOG[h][2][10]))
    
    dev_c_ext.append((HISTO_LOG[h][2][3]))
   
#------------------------------------------------------------------------------

#plot user costs development
    
#plot lines and ticks    
plt.axhline(y=0, xmin=0.05, xmax=0.95, color=cl_black[0])
plt.plot(x,  dev_C_tot,  label='Total System costs',        color = cl_purple_bright[0],   linewidth = 2)
plt.plot(x,  dev_C_user, label='Total User Costs',         color = cl_red[2],     linewidth = 2)
plt.stackplot(x, (dev_c_invehicle_ptv, dev_c_access_ptv, dev_c_waiting_ptv, dev_c_transfer_ptv ), 
                 colors=[cl_purple_light[2], cl_yellow[2], cl_red[3], cl_orange[2]],
                 labels=['In-Vehicle','Access & Egress','Waiting','Transfer'])
plt.stackplot(x, (dev_c_invehicle_ngt, dev_c_access_ngt, dev_c_waiting_ngt, dev_c_transfer_ngt ), 
                  colors=[cl_purple_light[2], cl_yellow[2], cl_red[3], cl_orange[2]])

#define grpah characteristics
plt.title('Cost development (user)')
plt.legend(bbox_to_anchor=(1., 1.0))
plt.xlabel('Iteration [-]')
plt.ylabel('Costs [Euro]') ; #plt.ylim((min( min(), min(), min(), min(), min(), min(), min())))*1.1, max(dev_C_oper)* 1.1))
plt.show()

#------------------------------------------------------------------------------

#plot operator costs development

#plot lines and ticks
plt.axhline(y=0, xmin=0.05, xmax=0.95, color=cl_black[0])
plt.plot(x,  dev_C_tot,  label='Total System Costs',        color = cl_purple_bright[0],   linewidth = 2)
plt.plot(x,  dev_C_oper, label='Total Operators Costs',    color = cl_blue_dark[0],       linewidth = 2)
plt.stackplot(x, (dev_c_RSo, dev_c_RSm), 
                  colors= [cl_blue_dark[2], cl_blue_dark[3]],
                  labels= ['Operational' ,'Maintenance'])

#define grpah characteristics
plt.title('Cost development (operator)')
plt.legend(bbox_to_anchor=(1., 1.0))
plt.xlabel('Iteration [-]')
plt.ylabel('Costs [Euro]') ; #plt.ylim((min(dev_C_user)*1.1, max(dev_C_oper) * 1.1))
plt.show()

#-----------------------------------------------------------------------------

#plot external costs development

#plot lines and ticks
plt.axhline(y=0, xmin=0.05, xmax=0.95, color=cl_black[0])
plt.plot(x,  dev_C_ext,  label='Total external costs',    color = cl_green_light[1],       linewidth = 2)
plt.plot(x,  dev_C_tot,  label='Total costs',        color = cl_purple_bright[0],   linewidth = 2)
plt.stackplot(x, (dev_c_ext), colors= [cl_green_dark[3]])

#define grpah characteristics
plt.title('Cost development (external)')
plt.legend(bbox_to_anchor=(1., 1.0))
plt.xlabel('Iteration [-]')
plt.ylabel('Costs [Euro]') ; #plt.ylim((min(dev_C_user)*1.1, max(dev_C_oper) * 1.1))
plt.show()

#-----------------------------------------------------------------------------

#development objective function plot
dev_Z = ([]); dev_OV_user = ([]); dev_OV_oper = ([]); dev_OV_ext = ([])
for h in range(len(HISTO_LOG)):
    dev_Z.append(HISTO_LOG[h][2][0])
    dev_OV_user.append(HISTO_LOG[h][2][1] * PSI_user)
    dev_OV_oper.append(HISTO_LOG[h][2][2] * PSI_operator)
    dev_OV_ext.append(HISTO_LOG[h][2][3] * PSI_external)

#plot lines and ticks
y1=dev_OV_oper; y2=dev_OV_user; y3=dev_OV_ext
plt.axhline(y=0, xmin=0.05, xmax=0.95, color=cl_black[0])
plt.stackplot(x,dev_Z,colors=[cl_purple_bright[3]])
plt.plot(x,  y1,         label='Total operator contribution',    color = cl_blue_dark[0],       linewidth = 2)
plt.plot(x,  y3,         label='Total external contribution',     color = cl_green_light[1],     linewidth = 2)
plt.plot(x,  y2,         label='Total user contribution',         color = cl_red[2],             linewidth = 2)
plt.plot(x,  dev_Z,  label='Total objective value',        color = cl_purple_bright[0],   linewidth = 2)

#plt.axvline(x=iteration_end6, color = 'k')
#plt.axvline(x=iteration_end8, color = 'k')

#define grpah characteristics
plt.title('Objective function value development')
plt.legend(bbox_to_anchor=(1., 1.0))
plt.xlabel('Iteration [-]')
plt.ylabel('Objective value [-]')
plt.show()


#------------------------------------------------------------------------------

#modal split development graph

#construct historical value arrays
dev_MS_air = ([]); dev_MS_hsr = ([]); dev_MS_car = ([])
for h in range(len(HISTO_LOG)):
    dev_MS_air.append((HISTO_LOG[h][2][11] / np.sum(DM)) * 100)
    dev_MS_hsr.append((HISTO_LOG[h][2][12] / np.sum(DM)) * 100)
    dev_MS_car.append((HISTO_LOG[h][2][13] / np.sum(DM)) * 100)
x=range(0,len(HISTO_LOG))
y=[dev_MS_car, dev_MS_hsr, dev_MS_air]

#plot lines and ticks
plt.stackplot(x,y, labels=['Car' ,'HST','Airplane'], colors=[cl_blue_light[0],cl_green_light[0],cl_blue_dark[0]] )
#plt.axvline(x=iteration_end6, color = 'k')
#plt.axvline(x=iteration_end8, color = 'k')       
  
#define grpah characteristics
plt.title('Modal split development during algorithm excecution')
plt.legend(bbox_to_anchor=(1., 1.0))
plt.xlabel('Iteration [-]') ; #plt.xlim((0, len(HISTO_LOG)-1))
plt.ylabel('Modal split [%]'); #plt.ylim((0, 100))
plt.show()

#------------------------------------------------------------------------------
#travel times graph
dev_tt_air = ([]); dev_tt_hsr = ([]); dev_tt_car = ([]); dev_tt_tot = ([])
for h in range(len(HISTO_LOG)):
    dev_tt_air.append(HISTO_LOG[h][2][14])
    dev_tt_hsr.append(HISTO_LOG[h][2][15])
    dev_tt_car.append(HISTO_LOG[h][2][16])
    dev_tt_tot.append(HISTO_LOG[h][2][14]+HISTO_LOG[h][2][15]+HISTO_LOG[h][2][16])
x=range(0,len(HISTO_LOG))
y1=dev_tt_air; y2=dev_tt_hsr; y3=dev_tt_car; y4=dev_tt_tot


#plot lines and ticks
plt.plot(x,y1, label='Airplane', linewidth = 2 , color = cl_blue_dark[0])
plt.plot(x,y2, label='HST', linewidth = 2, color = cl_green_light[0])
plt.plot(x,y3, label='Car', linewidth = 2, color = cl_blue_light[0])
#plt.axvline(x=iteration_end6, color = 'k')
#plt.axvline(x=iteration_end8, color = 'k')

#define grpah characteristics
plt.title('Aggregated travel time development')
plt.legend(bbox_to_anchor=(1., 1.0))
plt.xlabel('Iteration [-]') ; plt.xlim((0 - (len(HISTO_LOG)-1) *0.1 , (len(HISTO_LOG)-1) * 1.1))
plt.ylabel('Aggregated travel time per mode [h]') ; plt.ylim((0, max( max(y1), max(y2), max(y3) ) *1.1))
plt.show()

"""----------------------------------------------------------------------------
--------------------------------  POSTSCRIPT  ---------------------------------
-----------------------------  Algorithm Report  ------------------------------
----------------------------------------------------------------------------"""

#------------------------------------------------------------------------------

time_begin_post = time.time()

#------------------------------------------------------------------------------
#construction of best_path_history past
#secondary analysis cannot use reduced NAP

pax_splits_tot = np.zeros(len(HISTO_LOG), dtype=object)
for h in range(len(HISTO_LOG)):
    pax_splits_tot[h]    =     ( [float('nan'),float('nan'),float('nan'),float('nan')],
                                 [float('nan'),float('nan'),float('nan'),float('nan')],
                                 [float('nan'),float('nan'),float('nan')] )

pax_splits_city = np.empty((length_V, length_V, len(HISTO_LOG)), dtype=object)
for h in range(len(HISTO_LOG)):
    for i in range_len_V:
        for j in range_len_V:
            pax_splits_city[i,j][h] = ( [float('nan'),float('nan'),float('nan'),float('nan')],
                                     [float('nan'),float('nan'),float('nan'),float('nan')],
                                     [float('nan'),float('nan'),float('nan'),float('nan')] )

#construction of historical iteration neighbourhoods
for h in range(len(HISTO_LOG)):
    if h > 0:
        IN_historical = np.zeros((3), dtype=object)
        IN_historical[0] = HISTO_LOG[h][0]
        IN_historical[1] = np.zeros(n_lines)
        IN_historical[2] = np.zeros(n_KPIs) 
       
        #perform analysis on historical iteration
        A_historical = NETWORK_ANALYSIS_PROCEDURE(IN_historical)
        #print A_historical[2]
        #perform NAP on primary neighbourhood space
        no_pax_0 = 0 ; no_pax_1 = 0; no_pax_2 = 0; no_pax_spilled = 0
        P_0 = 0 ; P_1 = 0; P_2 = 0; P_spilled = 0
        no_pax_hsr_tot = 0
        
        #loop through best path matrix in order to find pax spread
        for i in range_len_V:
            for j in range_len_V:
                if i != j:
                    if A_historical[2][i,j][0] == 0 and A_historical[2][i,j][2] > 0 + epsilon0:
                        no_pax_0 = no_pax_0 + A_historical[4][i,j]

                    if A_historical[2][i,j][0] == 1:
                        no_pax_1 = no_pax_1 + A_historical[4][i,j]
                        
                    if A_historical[2][i,j][0] == 2:
                        no_pax_2 = no_pax_2 + A_historical[4][i,j]
    
        
        #determine number of total HSR passengers in this iteration
        no_pax_hsr_tot = (no_pax_0 + no_pax_1 + no_pax_2)
        
        #determine number of spilled passengers compared to primary neighbourhood

        no_pax_spilled = no_pax_hsr_pot - no_pax_0 - no_pax_1 - no_pax_2
        
 
        #fill pax_splits_tot matrix
        pax_splits_tot[h][0][0] = no_pax_0                             #total number of T0 travellers
        pax_splits_tot[h][0][1] = no_pax_1                             #total number of T1 travellers
        pax_splits_tot[h][0][2] = no_pax_2                             #total number of T2 travellers
        pax_splits_tot[h][0][3] = no_pax_spilled                       #total number of spilled travellers

        pax_splits_tot[h][1][0] = no_pax_0         /  no_pax_hsr_pot   #percentage T0 travellers (estimated total demand based on MS_hsr_predictor)
        pax_splits_tot[h][1][1] = no_pax_1         /  no_pax_hsr_pot   #percentage T1 travellers (estimated total demand based on MS_hsr_predictor)
        pax_splits_tot[h][1][2] = no_pax_2         /  no_pax_hsr_pot   #percentage T2 travellers (estimated total demand based on MS_hsr_predictor)
        pax_splits_tot[h][1][3] = no_pax_spilled   /  no_pax_hsr_pot   #percentage spilled (estimated total demand based on MS_hsr_predictor)
        
        pax_splits_tot[h][2][0] = no_pax_0         /  no_pax_hsr_tot   #percentage T0 travellers (of this iterations hsr travellers)
        pax_splits_tot[h][2][1] = no_pax_1         /  no_pax_hsr_tot   #percentage T1 travellers (of this iterations hsr travellers)
        pax_splits_tot[h][2][2] = no_pax_2         /  no_pax_hsr_tot   #percentage T02 travellers (of this iterations hsr travellers)
        
        #determine total number of hsr passengers per city
        for i in range_len_V:
            for j in range_len_V:
                if i != j:
                    if A_historical[2][i,j][0] == 0 and A_historical[2][i,j][2] > 0 + epsilon0:
                        pax_splits_city[i,j][h][0][0] = A_historical[4][i,j]
                    if A_historical[2][i,j][0] == 1:
                        pax_splits_city[i,j][h][0][1] = A_historical[4][i,j]
                    if A_historical[2][i,j][0] == 2:
                        pax_splits_city[i,j][h][0][2] = A_historical[4][i,j]
                    if A_historical[2][i,j][0] == 0 and A_historical[2][i,j][2] < 0 + epsilon0: 
                        pax_splits_city[i,j][h][0][3] = 0 
                        
        #fill pax_splits_city matrix        
        for i in range_len_V:
            for j in range_len_V:
                if i != j:
                    pax_splits_city[i,j][h][1][0] = A_historical[3][i,j]
                    pax_splits_city[i,j][h][1][1] = A_historical[4][i,j]
                    pax_splits_city[i,j][h][1][2] = A_historical[5][i,j]
                    pax_splits_city[i,j][h][1][3] = A_historical[3][i,j] + A_historical[4][i,j] + A_historical[5][i,j]
                    
                    pax_splits_city[i,j][h][2][0] = A_historical[3][i,j] / (pax_splits_city[i,j][h][1][3])
                    pax_splits_city[i,j][h][2][1] = A_historical[4][i,j] / (pax_splits_city[i,j][h][1][3])
                    pax_splits_city[i,j][h][2][2] = A_historical[5][i,j] / (pax_splits_city[i,j][h][1][3])
                    pax_splits_city[i,j][h][2][3] = 1.0
                    
                    #print pax_splits_city[i,j][h][0]
                    #print pax_splits_city[i,j][h][1]
                    #print pax_splits_city[i,j][h][2]
                    #print ''
#------------------------------------------------------------------------------

#plot passenger transfer numbers  

dev_no_pax_0 = ([]); dev_no_pax_1 = ([]); dev_no_pax_2 = ([]); dev_no_pax_spilled95 = ([]); dev_no_pax_spilled05 = ([])
for h in range(len(HISTO_LOG)):
    dev_no_pax_0.append(pax_splits_tot[h][0][0])
    dev_no_pax_1.append(pax_splits_tot[h][0][1])
    dev_no_pax_2.append(pax_splits_tot[h][0][2])
    dev_no_pax_spilled95.append(demand_resolution/100*pax_splits_tot[h][0][3])
    dev_no_pax_spilled05.append((100-demand_resolution)/100*pax_splits_tot[h][0][3])

              
x=range(0,len(HISTO_LOG))               
plt.stackplot(x, (dev_no_pax_0, dev_no_pax_1, dev_no_pax_2, dev_no_pax_spilled95,dev_no_pax_spilled05 ), colors=['#821066', '#AF168A','#E52Db8', '#b4b4b3', '#696868'], labels=['Direct path','1-Transfer path','2-Transfer paths', 'Est. spilled passengers','Est. potential (out-of-scope)'])
plt.legend(bbox_to_anchor=(1.35, 1.0))
plt.xlabel('iteration')
plt.ylabel('number of passengers')
plt.title('Passenger transfer behaviour')
plt.show()

#------------------------------------------------------------------------------

#plot passenger transfer percentages 

dev_P0 = ([]); dev_P1 = ([]); dev_P2 = ([])
for h in range(len(HISTO_LOG)):
    dev_P0.append(pax_splits_tot[h][2][0]*100)
    dev_P1.append(pax_splits_tot[h][2][1]*100)
    dev_P2.append(pax_splits_tot[h][2][2]*100)

              
x=range(0,len(HISTO_LOG))               
plt.stackplot(x, (dev_P0, dev_P1, dev_P2), colors=['#821066', '#AF168A','#E52Db8'], labels=['Direct path','1-Transfer path','2-Transfer paths'])
plt.legend(bbox_to_anchor=(1.35, 1.0))
plt.xlabel('Iteration')
plt.ylabel('percentage of passengers')
plt.title('Passenger transfer behaviour')
plt.show()


#------------------------------------------------------------------------------

#modal split over distance (MSD)
MSD_distance_gaps = 100
MSD_max_distance = int(math.ceil(np.max(DS_gc))) + MSD_distance_gaps
MSD_N_steps = MSD_max_distance / MSD_distance_gaps
MSD_distance_array = ([0])

#for N in range(MSD_N_steps):
for N in range(MSD_N_steps):
    MSD_distance_array.append(MSD_distance_gaps*(N+1))

MSD_demand_air = np.zeros(len(MSD_distance_array))
MSD_demand_hsr = np.zeros(len(MSD_distance_array))
MSD_demand_car = np.zeros(len(MSD_distance_array))
MSD_demand_total = np.full(len(MSD_distance_array),np.inf)

for i in range_len_V:
    for j in range_len_V:
        if i < j:
            MSD_bin = int(round(DS_gc[i,j] / MSD_distance_gaps))
            MSD_demand_air[MSD_bin] = MSD_demand_air[MSD_bin] + A_historical[3][i,j]  + A_historical[3][j,i]
            MSD_demand_hsr[MSD_bin] = MSD_demand_hsr[MSD_bin] + A_historical[4][i,j]  + A_historical[4][j,i] 
            MSD_demand_car[MSD_bin] = MSD_demand_car[MSD_bin] + A_historical[5][i,j]  + A_historical[5][j,i]

for N in range(MSD_N_steps+1):
    MSD_demand_total[N] = MSD_demand_air[N] +  MSD_demand_hsr[N]  +  MSD_demand_car[N]
    if MSD_demand_total[N] == 0:
        MSD_demand_total[N] = np.inf
    MSD_demand_air[N] = (MSD_demand_air[N] / MSD_demand_total[N] * 100)
    MSD_demand_hsr[N] = (MSD_demand_hsr[N] / MSD_demand_total[N] * 100)
    MSD_demand_car[N] = (MSD_demand_car[N] / MSD_demand_total[N] * 100)

#define lines to be plotted
y1=MSD_demand_air; y2=MSD_demand_hsr; y3=MSD_demand_car

#define resolution for graph
x_new = np.linspace(0, MSD_max_distance, 400)

#extrapolate all values for graph
y1_BSpline = sy.interpolate.make_interp_spline(MSD_distance_array, y1)
y1_new = y1_BSpline(x_new)
y2_BSpline = sy.interpolate.make_interp_spline(MSD_distance_array, y2)
y2_new = y2_BSpline(x_new)
y3_BSpline = sy.interpolate.make_interp_spline(MSD_distance_array, y3)
y3_new = y3_BSpline(x_new)

#plot lines and ticks
plt.plot(x_new,y1_new, label='Plane',color=cl_blue_dark[0], linewidth = 2)
plt.plot(x_new,y2_new, label='HST',color=cl_green_light[0],linewidth = 2)
plt.plot(x_new,y3_new, label='Car',color=cl_blue_light[0],linewidth = 2)
plt.plot(MSD_distance_array,MSD_demand_air, 'o', color=cl_blue_dark[0]);
plt.plot(MSD_distance_array,MSD_demand_hsr, 'o', color=cl_green_light[0]);
plt.plot(MSD_distance_array,MSD_demand_car, 'o', color=cl_blue_light[0]);
         
#define grpah characteristics
plt.title('Modal split per distance')
plt.legend(bbox_to_anchor=(1., 1.0))
plt.xlabel('Distance (greater circle) [km]') ; plt.xlim((0, MSD_distance_array[len(MSD_distance_array)-2])); plt.xlim((200,1500))
plt.ylabel('Market share [%]'); plt.ylim((0, 100))
plt.show()


#printing the results of the  HISTO_log
remaining_lines = (([]))

for k in range(len(POOL_OF_LINES)):
    if HISTO_LOG[len(HISTO_LOG)-1][0][k] == 1:
        remaining_lines.append([k, POOL_OF_LINES[k][2], HISTO_LOG[len(HISTO_LOG)-1][1][k]])

for a in range(len(remaining_lines)):
    print remaining_lines[a]
 
#for k in range(len(POOL_OF_LINES)):
    #print k, POOL_OF_LINES[k][2], '(',POOL_OF_LINES[k][6],')', '(',POOL_OF_LINES[k][4],')'



#------------------------------------------------------------------------------

#change looks
sns.set_style("whitegrid")
figure(figsize=(8,len(remaining_lines)/1.8))

#determine length of maximum line
max_distance = 0
for a in range(len(remaining_lines)):
    if max_distance < POOL_OF_LINES[remaining_lines[a][0]][4]:
        max_distance = POOL_OF_LINES[remaining_lines[a][0]][4]

#plot lines
for a in range(len(remaining_lines)):
    plt.plot([0, (POOL_OF_LINES[remaining_lines[a][0]][4] / fac_dt[1])], [(len(remaining_lines)-a), (len(remaining_lines)-a)], '-', color=cl_blue_light[2], linewidth=2) 
    plt.text(0   , len(remaining_lines)-a + 0.15, POOL_OF_LINES[remaining_lines[a][0]][2][0], verticalalignment='bottom', horizontalalignment = 'center', color = cl_blue_dark[0], fontsize='small')
    plt.plot(0, len(remaining_lines)-a , 'o', color=cl_blue_dark[0])
    sumdistance=0 ; newdistance = 0
    for b in range(len(POOL_OF_LINES[remaining_lines[a][0]][2])-1):
        newdistance = DS_gc[Vnum(POOL_OF_LINES[remaining_lines[a][0]][2][b]),Vnum(POOL_OF_LINES[remaining_lines[a][0]][2][b+1])]
        sumdistance = sumdistance + newdistance
        plt.plot(sumdistance, len(remaining_lines)-a , 'o', color=cl_blue_dark[0])
        plt.text(sumdistance, len(remaining_lines)-a + 0.15 , POOL_OF_LINES[remaining_lines[a][0]][2][b+1], verticalalignment='bottom', horizontalalignment = 'center', color = cl_blue_dark[0], fontsize='small')
        plt.text(sumdistance - 0.5*newdistance, len(remaining_lines)-a + 0.10 , int(newdistance), verticalalignment='bottom', horizontalalignment = 'center', color = cl_blue_light[0], fontsize='small' )
         
#define grpah characteristics
plt.title('Set of lines')
plt.xlabel('Distance (greater circle per arc) [km]') ; plt.xlim((0 - (max_distance / fac_dt[1] *0.05), max_distance / fac_dt[1] * 1.05))
positions = range(len(remaining_lines)+1)
labels = np.full(len(remaining_lines)+1, '')
plt.yticks(positions, labels)
plt.ylabel(''); plt.ylim((0.5, len(remaining_lines)+0.8))
plt.savefig('line_chart.pdf')
plt.show()
















'''
#teken kaart met loads per edge

fig = plt.figure(figsize=(15,15)) #50,50
m = Basemap(projection='lcc', resolution='c',
            lon_0=12.5, lat_0=52, lat_1=40, lat_2=60, 
            width=4E6, height=3.5E6) #lon_0=12.5, lat_0=52, lat_1=40, lat_2=60, width=4E6, height=3.5E6)

m.drawcoastlines()
m.fillcontinents(color="#FFDDCC", lake_color='#DDEEFF')
m.drawmapboundary(fill_color="#DDEEFF")
m.drawcountries()


#add edges
for i in range_len_V:
    for j in range_len_V:
        if i != j:
            if i > j:
                if E[i,j] == 1:
                    m.drawgreatcircle(V_lon[i],V_lat[i],V_lon[j],V_lat[j],linewidth=10,color='#b4b4b3')

E_weight = np.zeros((length_V,length_V))

for a in range(len(remaining_lines)):
    for s in range(len(remaining_lines[a][1])-1):
        #print Vnum(remaining_lines[a][1][s]) ,'to', Vnum(remaining_lines[a][1][s+1])
        E_weight[Vnum(remaining_lines[a][1][s]), Vnum(remaining_lines[a][1][s+1])] = E_weight[Vnum(remaining_lines[a][1][s]), Vnum(remaining_lines[a][1][s+1])] + remaining_lines[a][2]
        E_weight[Vnum(remaining_lines[a][1][s+1]), Vnum(remaining_lines[a][1][s])] = E_weight[Vnum(remaining_lines[a][1][s+1]), Vnum(remaining_lines[a][1][s])] + remaining_lines[a][2]

E_weight_max = np.max(E_weight)    
for i in range_len_V:
    for j in range_len_V:
        E_weight[i,j] = E_weight[i,j] / E_weight_max
        

#add coloured edges
for i in range_len_V:
    for j in range_len_V:
        if i != j:
            if i > j:
                if E[i,j] == 1:
                    m.drawgreatcircle(V_lon[i],V_lat[i],V_lon[j],V_lat[j],linewidth=10*E_weight[i,j],color='#821066')
                                                        
#add vertices     
for i in range_len_V: 
    x, y = m(V_lon[i], V_lat[i])
    plt.plot(x, y, 'ok', markersize=20, color='#00415F') #plt.plot(x, y, 'ok', markersize=20, color='#00415F') 
    plt.plot(x, y, 'ok', markersize=15, color='#007896') #plt.plot(x, y, 'ok', markersize=15, color='#007896')
    x, y = m(V_lon[i]-0.06, V_lat[i]-0.06)   # x, y = m(V_lon[i]-0.06, V_lat[i]-0.06)      
    plt.text(x, y, V_letter[i], fontsize=10, color='w'); #plt.text(x, y, V_letter[i], fontsize=10, color='w');
plt.show()
'''


#------------------------------------------------------------------------------

#print run time report

from prettytable import PrettyTable
rtr = PrettyTable(['Operation', 'Run time [s]'])
rtr.add_row(['Initialisation', ("%s" %  round((time_begin_1 - time_begin_init),4))])
rtr.add_row(['1', ("%s" % round((time_begin_2 - time_begin_1),1))])
rtr.add_row(['2', ("%s" % round((time_begin_3 - time_begin_2),1))])
rtr.add_row(['3', ("%s" % round((time_begin_4 - time_begin_3),1))])
rtr.add_row(['4', ("%s" % round((time_begin_5 - time_begin_4),1))])
rtr.add_row(['5', ("%s" % round((time_begin_6 - time_begin_5),1))])
rtr.add_row(['6', ("%s" % round((time_begin_7 - time_begin_6),1))])
rtr.add_row(['7', ("%s" % round((time_begin_8 - time_begin_7),1))])
rtr.add_row(['8', ("%s" % round((time_begin_9 - time_begin_8),1))])
rtr.add_row(['9', ("%s" % round((time_begin_10 - time_begin_9),1))])
rtr.add_row(['10', ("%s" % round((time_begin_post - time_begin_10),1))])
rtr.add_row(['--------------', '----------------'])
rtr.add_row(['TOTAL', ("%s" % round((time.time() - start_time),4))])
print(rtr)

#------------------------------------------------------------------------------

#print intermediate output report

ior = PrettyTable(['Operation', 'Output', 'Result'])
ior.add_row(['Init', 'Number of Vertices', length_V])
ior.add_row(['Init', 'Number of Edges', E.sum() / 2])
ior.add_row(['---------', '---------', '---------'])
ior.add_row(['1', 'Number of generated lines', ((length_V**2) -length_V)/2])
ior.add_row(['---------', '---------', '---------'])
ior.add_row(['4', 'Number of generated lines', n_lines_uncs - ((length_V**2) -length_V)/2])
ior.add_row(['---------', '---------', '---------'])
ior.add_row(['5', 'Total number of generated lines', n_lines_uncs])
ior.add_row(['5', 'Number of infeasible lines', n_lines_uncs - n_lines_cons])
ior.add_row(['5', 'Total size Pool of Lines', n_lines_cons])
ior.add_row(['---------', '---------', '---------'])
ior.add_row(['6', 'Number of eliminated lines', int(n_lines_cons - n_lines_6end)])
ior.add_row(['6', 'Number of remaining lines', int(n_lines_6end)])
ior.add_row(['6', 'Initial Objective Value', round(HISTO_LOG[0][2][0],0)])
ior.add_row(['6', 'Final Objective Value', round(HISTO_LOG[len(HISTO_LOG)-1][2][0],0)])
ior.add_row(['---------', '---------', '---------'])
ior.add_row(['7', 'xxx', 'xxx'])
ior.add_row(['---------', '---------', '---------'])
ior.add_row(['8', 'Number of eliminated lines', 'xxx'])
ior.add_row(['8', 'Number of remaining lines', 'xxx'])
ior.add_row(['8', 'Initial Objective Value', round(HISTO_LOG[0][2][0],0)])
ior.add_row(['8', 'Final Objective Value', 'xxx'])
ior.add_row(['---------', '---------', '---------'])
ior.add_row(['9', 'xxx', 'xxx'])
ior.add_row(['---------', '---------', '---------'])
ior.add_row(['10', 'Number of moves performed', 'xxx'])
ior.add_row(['10', 'Number of lines eliminated', 'xxx'])
ior.add_row(['10', 'Number of remaining lines', 'xxx'])
ior.add_row(['10', 'Initial Objective Value', round(HISTO_LOG[0][2][0],0)])
ior.add_row(['10', 'Final Objective Value', 'xxx'])
ior.add_row(['---------', '---------', '---------'])
ior.add_row(['post', 'Number of NAP_consults', counter_NAP])

print(ior)

#------------------------------------------------------------------------------

#produce objective value table
ovt = PrettyTable(['Iteration', 'Z', 'C_user', 'C_operator', 'C_external'])
for H in range(len(HISTO_LOG)):
    ovt.add_row([ H ,round(HISTO_LOG[H][2][0],0), round(HISTO_LOG[H][2][1],0), round(HISTO_LOG[H][2][2],0), round(HISTO_LOG[H][2][3],0)])    
print ovt

#------------------------------------------------------------------------------

